/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class UnionTypeDefinition
extends AbstractNode<UnionTypeDefinition>
implements TypeDefinition<UnionTypeDefinition>,
DirectivesContainer<UnionTypeDefinition> {
    private final String name;
    private final Description description;
    private final List<Directive> directives;
    private final List<Type> memberTypes;

    @Internal
    protected UnionTypeDefinition(String name, List<Directive> directives, List<Type> memberTypes, Description description, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.directives = directives;
        this.memberTypes = memberTypes;
        this.description = description;
    }

    public UnionTypeDefinition(String name, List<Directive> directives) {
        this(name, directives, new ArrayList<Type>(), null, null, new ArrayList<Comment>());
    }

    public UnionTypeDefinition(String name) {
        this(name, new ArrayList<Directive>(), new ArrayList<Type>(), null, null, new ArrayList<Comment>());
    }

    @Override
    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    public List<Type> getMemberTypes() {
        return new ArrayList<Type>(this.memberTypes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.memberTypes);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionTypeDefinition that = (UnionTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public UnionTypeDefinition deepCopy() {
        return new UnionTypeDefinition(this.name, this.deepCopy(this.directives), this.deepCopy(this.memberTypes), this.description, this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "UnionTypeDefinition{name='" + this.name + '\'' + "directives=" + this.directives + ", memberTypes=" + this.memberTypes + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitUnionTypeDefinition(this, context);
    }

    public static Builder newUnionTypeDefinition() {
        return new Builder();
    }

    public UnionTypeDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Description description;
        private List<Directive> directives = new ArrayList<Directive>();
        private List<Type> memberTypes = new ArrayList<Type>();

        private Builder() {
        }

        private Builder(UnionTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = existing.getDirectives();
            this.memberTypes = existing.getMemberTypes();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives.add(directive);
            return this;
        }

        public Builder memberTypes(List<Type> memberTypes) {
            this.memberTypes = memberTypes;
            return this;
        }

        public Builder memberType(Type memberType) {
            this.memberTypes.add(memberType);
            return this;
        }

        public UnionTypeDefinition build() {
            UnionTypeDefinition unionTypeDefinition = new UnionTypeDefinition(this.name, this.directives, this.memberTypes, this.description, this.sourceLocation, this.comments);
            return unionTypeDefinition;
        }
    }
}

