/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class VariableDefinition
extends AbstractNode<VariableDefinition>
implements NamedNode<VariableDefinition> {
    private final String name;
    private final Type type;
    private final Value defaultValue;

    @Internal
    protected VariableDefinition(String name, Type type, Value defaultValue, SourceLocation sourceLocation, List<Comment> comments) {
        super(sourceLocation, comments);
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public VariableDefinition(String name, Type type, Value defaultValue) {
        this(name, type, defaultValue, null, new ArrayList<Comment>());
    }

    public VariableDefinition(String name, Type type) {
        this(name, type, null, null, new ArrayList<Comment>());
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        if (this.defaultValue != null) {
            result.add(this.defaultValue);
        }
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDefinition that = (VariableDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public VariableDefinition deepCopy() {
        return new VariableDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.defaultValue), this.getSourceLocation(), this.getComments());
    }

    public String toString() {
        return "VariableDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitVariableDefinition(this, context);
    }

    public static Builder newVariableDefinition() {
        return new Builder();
    }

    public static Builder newVariableDefinition(String name) {
        return new Builder().name(name);
    }

    public static Builder newVariableDefinition(String name, Type type) {
        return new Builder().name(name).type(type);
    }

    public static Builder newVariableDefinition(String name, Type type, Value defaultValue) {
        return new Builder().name(name).type(type).defaultValue(defaultValue);
    }

    public VariableDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private String name;
        private List<Comment> comments = new ArrayList<Comment>();
        private Type type;
        private Value defaultValue;

        private Builder() {
        }

        private Builder(VariableDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.type = existing.getType();
            this.defaultValue = existing.getDefaultValue();
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Value defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public VariableDefinition build() {
            VariableDefinition variableDefinition = new VariableDefinition(this.name, this.type, this.defaultValue, this.sourceLocation, this.comments);
            return variableDefinition;
        }
    }
}

