/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLDirective
implements GraphQLType {
    private final String name;
    private final String description;
    private final EnumSet<Introspection.DirectiveLocation> locations;
    private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
    private final boolean onOperation;
    private final boolean onFragment;
    private final boolean onField;

    public GraphQLDirective(String name, String description, EnumSet<Introspection.DirectiveLocation> locations, List<GraphQLArgument> arguments, boolean onOperation, boolean onFragment, boolean onField) {
        Assert.assertValidName(name);
        Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.locations = locations;
        this.arguments.addAll(arguments);
        this.onOperation = onOperation;
        this.onFragment = onFragment;
        this.onField = onField;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<GraphQLArgument> getArguments() {
        return new ArrayList<GraphQLArgument>(this.arguments);
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public EnumSet<Introspection.DirectiveLocation> validLocations() {
        return this.locations;
    }

    @Deprecated
    public boolean isOnOperation() {
        return this.onOperation;
    }

    @Deprecated
    public boolean isOnFragment() {
        return this.onFragment;
    }

    @Deprecated
    public boolean isOnField() {
        return this.onField;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "GraphQLDirective{name='" + this.name + '\'' + ", arguments=" + this.arguments + ", locations=" + this.locations + '}';
    }

    public GraphQLDirective transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLDirective.newDirective(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLDirective(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        return new ArrayList<GraphQLType>(this.arguments);
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static Builder newDirective(GraphQLDirective existing) {
        return new Builder(existing);
    }

    public static class Builder {
        private String name;
        private String description;
        private boolean onOperation;
        private boolean onFragment;
        private boolean onField;
        private EnumSet<Introspection.DirectiveLocation> locations = EnumSet.noneOf(Introspection.DirectiveLocation.class);
        private final Map<String, GraphQLArgument> arguments = new LinkedHashMap<String, GraphQLArgument>();

        public Builder() {
        }

        public Builder(GraphQLDirective existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.onOperation = existing.isOnOperation();
            this.onFragment = existing.isOnFragment();
            this.onField = existing.isOnField();
            this.locations = existing.validLocations();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), GraphQLArgument::getName));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder validLocations(Introspection.DirectiveLocation ... validLocations) {
            Collections.addAll(this.locations, validLocations);
            return this;
        }

        public Builder validLocation(Introspection.DirectiveLocation validLocation) {
            this.locations.add(validLocation);
            return this;
        }

        public Builder clearValidLocations() {
            this.locations = EnumSet.noneOf(Introspection.DirectiveLocation.class);
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            Assert.assertNotNull(argument, "argument must not be null", new Object[0]);
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            return this.argument(builder.build());
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        @Deprecated
        public Builder onOperation(boolean onOperation) {
            this.onOperation = onOperation;
            return this;
        }

        @Deprecated
        public Builder onFragment(boolean onFragment) {
            this.onFragment = onFragment;
            return this;
        }

        @Deprecated
        public Builder onField(boolean onField) {
            this.onField = onField;
            return this;
        }

        public GraphQLDirective build() {
            return new GraphQLDirective(this.name, this.description, this.locations, FpKit.valuesToList(this.arguments), this.onOperation, this.onFragment, this.onField);
        }
    }
}

