/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLEnumType
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLEnumValueDefinition> valueDefinitionMap = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
    private final EnumTypeDefinition definition;
    private final List<GraphQLDirective> directives;
    private final Coercing coercing = new Coercing(){

        public Object serialize(Object input) {
            return GraphQLEnumType.this.getNameByValue(input);
        }

        public Object parseValue(Object input) {
            return GraphQLEnumType.this.getValueByName(input);
        }

        private String typeName(Object input) {
            if (input == null) {
                return "null";
            }
            return input.getClass().getSimpleName();
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof EnumValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'EnumValue' but was '" + this.typeName(input) + "'.");
            }
            EnumValue enumValue = (EnumValue)input;
            GraphQLEnumValueDefinition enumValueDefinition = (GraphQLEnumValueDefinition)GraphQLEnumType.this.valueDefinitionMap.get(enumValue.getName());
            if (enumValueDefinition == null) {
                throw new CoercingParseLiteralException("Expected enum literal value not in allowable values -  '" + String.valueOf(input) + "'.");
            }
            return enumValueDefinition.getValue();
        }
    };

    @Internal
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values) {
        this(name, description, values, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values, List<GraphQLDirective> directives, EnumTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.directives = directives;
        this.buildMap(values);
    }

    public List<GraphQLEnumValueDefinition> getValues() {
        return new ArrayList<GraphQLEnumValueDefinition>(this.valueDefinitionMap.values());
    }

    public GraphQLEnumValueDefinition getValue(String name) {
        return this.valueDefinitionMap.get(name);
    }

    private void buildMap(List<GraphQLEnumValueDefinition> values) {
        for (GraphQLEnumValueDefinition valueDefinition : values) {
            String name = valueDefinition.getName();
            if (this.valueDefinitionMap.containsKey(name)) {
                throw new AssertException("value " + name + " redefined");
            }
            this.valueDefinitionMap.put(name, valueDefinition);
        }
    }

    private Object getValueByName(Object value) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(value.toString());
        if (enumValueDefinition != null) {
            return enumValueDefinition.getValue();
        }
        throw new CoercingParseValueException("Invalid input for Enum '" + this.name + "'. No value found for name '" + value.toString() + "'");
    }

    private Object getNameByValue(Object value) {
        for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
            Object definitionValue = valueDefinition.getValue();
            if (value.equals(definitionValue)) {
                return valueDefinition.getName();
            }
            if (!(definitionValue instanceof Enum) || !(value instanceof String) || !value.equals(((Enum)definitionValue).name())) continue;
            return valueDefinition.getName();
        }
        if (value instanceof Enum) {
            String enumNameValue = ((Enum)value).name();
            for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
                String definitionValue = String.valueOf(valueDefinition.getValue());
                if (!enumNameValue.equals(definitionValue)) continue;
                return valueDefinition.getName();
            }
        }
        throw new CoercingSerializeException("Invalid input for Enum '" + this.name + "'. Unknown value '" + value + "'");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    public EnumTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public GraphQLEnumType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumType.newEnum(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        ArrayList<GraphQLType> children = new ArrayList<GraphQLType>(this.valueDefinitionMap.values());
        children.addAll(this.directives);
        return children;
    }

    public static Builder newEnum() {
        return new Builder();
    }

    public static Builder newEnum(GraphQLEnumType existing) {
        return new Builder(existing);
    }

    public static class Builder {
        private String name;
        private String description;
        private EnumTypeDefinition definition;
        private final Map<String, GraphQLEnumValueDefinition> values = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLEnumType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.values.putAll(FpKit.getByName(existing.getValues(), GraphQLEnumValueDefinition::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(EnumTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder value(String name, Object value, String description, String deprecationReason) {
            this.value(new GraphQLEnumValueDefinition(name, description, value, deprecationReason));
            return this;
        }

        public Builder value(String name, Object value, String description) {
            return this.value(new GraphQLEnumValueDefinition(name, description, value));
        }

        public Builder value(String name, Object value) {
            Assert.assertNotNull(value, "value can't be null", new Object[0]);
            return this.value(new GraphQLEnumValueDefinition(name, null, value));
        }

        public Builder value(String name) {
            return this.value(new GraphQLEnumValueDefinition(name, null, name));
        }

        public Builder value(GraphQLEnumValueDefinition enumValueDefinition) {
            Assert.assertNotNull(enumValueDefinition, "enumValueDefinition can't be null", new Object[0]);
            this.values.put(enumValueDefinition.getName(), enumValueDefinition);
            return this;
        }

        public boolean hasValue(String name) {
            return this.values.containsKey(name);
        }

        public Builder clearValues() {
            this.values.clear();
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumType(this.name, this.description, FpKit.valuesToList(this.values), FpKit.valuesToList(this.directives), this.definition);
        }
    }
}

