/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLEnumValueDefinition
implements GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Object value;
    private final String deprecationReason;
    private final List<GraphQLDirective> directives;

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value) {
        this(name, description, value, null, Collections.emptyList());
    }

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason) {
        this(name, description, value, deprecationReason, Collections.emptyList());
    }

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason, List<GraphQLDirective> directives) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.value = value;
        this.deprecationReason = deprecationReason;
        this.directives = directives;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return DirectivesUtil.directivesByName(this.directives);
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public GraphQLEnumValueDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumValueDefinition.newEnumValueDefinition(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumValueDefinition(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        return new ArrayList<GraphQLType>(this.directives);
    }

    public static Builder newEnumValueDefinition() {
        return new Builder();
    }

    public static Builder newEnumValueDefinition(GraphQLEnumValueDefinition existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private Object value;
        private String deprecationReason;
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLEnumValueDefinition existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.value = existing.getValue();
            this.deprecationReason = existing.getDeprecationReason();
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder deprecationReason(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLEnumValueDefinition build() {
            return new GraphQLEnumValueDefinition(this.name, this.description, this.value, this.deprecationReason, FpKit.valuesToList(this.directives));
        }
    }
}

