/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.InputObjectTypeDefinition;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInputObjectType
implements GraphQLType,
GraphQLInputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLInputFieldsContainer,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLInputObjectField> fieldMap = new LinkedHashMap<String, GraphQLInputObjectField>();
    private final InputObjectTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields) {
        this(name, description, fields, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLInputObjectType(String name, String description, List<GraphQLInputObjectField> fields, List<GraphQLDirective> directives, InputObjectTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fields, "fields can't be null", new Object[0]);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.directives = directives;
        this.buildMap(fields);
    }

    private void buildMap(List<GraphQLInputObjectField> fields) {
        for (GraphQLInputObjectField field : fields) {
            String name = field.getName();
            if (this.fieldMap.containsKey(name)) {
                throw new AssertException("field " + name + " redefined");
            }
            this.fieldMap.put(name, field);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<GraphQLInputObjectField> getFields() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public GraphQLInputObjectField getField(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    @Override
    public GraphQLInputObjectField getFieldDefinition(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public List<GraphQLInputObjectField> getFieldDefinitions() {
        return new ArrayList<GraphQLInputObjectField>(this.fieldMap.values());
    }

    public InputObjectTypeDefinition getDefinition() {
        return this.definition;
    }

    public GraphQLInputObjectType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInputObjectType.newInputObject(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInputObjectType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        ArrayList<GraphQLType> children = new ArrayList<GraphQLType>(this.fieldMap.values());
        children.addAll(this.directives);
        return children;
    }

    public static Builder newInputObject(GraphQLInputObjectType existing) {
        return new Builder(existing);
    }

    public static Builder newInputObject() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private InputObjectTypeDefinition definition;
        private final Map<String, GraphQLInputObjectField> fields = new LinkedHashMap<String, GraphQLInputObjectField>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLInputObjectType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.fields.putAll(FpKit.getByName(existing.getFields(), GraphQLInputObjectField::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(InputObjectTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder field(GraphQLInputObjectField field) {
            Assert.assertNotNull(field, "field can't be null", new Object[0]);
            this.fields.put(field.getName(), field);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLInputObjectField.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, "builderFunction should not be null", new Object[0]);
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
            builder = (GraphQLInputObjectField.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLInputObjectField.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLInputObjectField> fields) {
            fields.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLInputObjectType build() {
            return new GraphQLInputObjectType(this.name, this.description, FpKit.valuesToList(this.fields), FpKit.valuesToList(this.directives), this.definition);
        }
    }
}

