/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.schema.idl.SchemaDirectiveWiringEnvironmentImpl;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.WiringFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class SchemaGeneratorDirectiveHelper {
    SchemaGeneratorDirectiveHelper() {
    }

    public GraphQLObjectType onObject(GraphQLObjectType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLObjectType>((GraphQLObjectType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onObject);
    }

    public GraphQLFieldDefinition onField(GraphQLFieldDefinition element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLFieldDefinition>((GraphQLFieldDefinition)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onField);
    }

    public GraphQLInterfaceType onInterface(GraphQLInterfaceType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInterfaceType>((GraphQLInterfaceType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onInterface);
    }

    public GraphQLUnionType onUnion(GraphQLUnionType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLUnionType>((GraphQLUnionType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onUnion);
    }

    public GraphQLScalarType onScalar(GraphQLScalarType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLScalarType>((GraphQLScalarType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onScalar);
    }

    public GraphQLEnumType onEnum(GraphQLEnumType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumType>((GraphQLEnumType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onEnum);
    }

    public GraphQLEnumValueDefinition onEnumValue(GraphQLEnumValueDefinition element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLEnumValueDefinition>((GraphQLEnumValueDefinition)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onEnumValue);
    }

    public GraphQLArgument onArgument(GraphQLArgument element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLArgument>((GraphQLArgument)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onArgument);
    }

    public GraphQLInputObjectType onInputObjectType(GraphQLInputObjectType element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectType>((GraphQLInputObjectType)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onInputObjectType);
    }

    public GraphQLInputObjectField onInputObjectField(GraphQLInputObjectField element, Parameters params) {
        return this.wireForEachDirective(params, element, element.getDirectives(), (outputElement, directive) -> new SchemaDirectiveWiringEnvironmentImpl<GraphQLInputObjectField>((GraphQLInputObjectField)outputElement, directive, params.getNodeParentTree(), params.getTypeRegistry(), params.getContext()), SchemaDirectiveWiring::onInputObjectField);
    }

    private <T extends GraphQLDirectiveContainer> T wireForEachDirective(Parameters parameters, T element, List<GraphQLDirective> directives, EnvBuilder<T> envBuilder, EnvInvoker<T> invoker) {
        T outputObject = element;
        for (GraphQLDirective directive : directives) {
            SchemaDirectiveWiringEnvironment<T> env = envBuilder.apply(outputObject, directive);
            Optional<SchemaDirectiveWiring> directiveWiring = this.discoverWiringProvider(parameters, directive.getName(), env);
            if (!directiveWiring.isPresent()) continue;
            SchemaDirectiveWiring schemaDirectiveWiring = directiveWiring.get();
            T newElement = invoker.apply(schemaDirectiveWiring, env);
            Assert.assertNotNull(newElement, "The SchemaDirectiveWiring MUST return a non null return value for element '" + element.getName() + "'", new Object[0]);
            outputObject = newElement;
        }
        return outputObject;
    }

    private <T extends GraphQLDirectiveContainer> Optional<SchemaDirectiveWiring> discoverWiringProvider(Parameters parameters, String directiveName, SchemaDirectiveWiringEnvironment<T> env) {
        RuntimeWiring runtimeWiring = parameters.getRuntimeWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        SchemaDirectiveWiring directiveWiring = wiringFactory.providesSchemaDirectiveWiring(env) ? Assert.assertNotNull(wiringFactory.getSchemaDirectiveWiring(env), "You MUST provide a non null SchemaDirectiveWiring", new Object[0]) : runtimeWiring.getDirectiveWiring().get(directiveName);
        return Optional.ofNullable(directiveWiring);
    }

    static interface EnvInvoker<T extends GraphQLDirectiveContainer> {
        public T apply(SchemaDirectiveWiring var1, SchemaDirectiveWiringEnvironment<T> var2);
    }

    static interface EnvBuilder<T extends GraphQLDirectiveContainer> {
        public SchemaDirectiveWiringEnvironment<T> apply(T var1, GraphQLDirective var2);
    }

    static class Parameters {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring runtimeWiring;
        private final NodeParentTree nodeParentTree;
        private final Map<String, Object> context;

        Parameters(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, NodeParentTree<NamedNode> nodeParentTree, Map<String, Object> context) {
            this.typeRegistry = typeRegistry;
            this.runtimeWiring = runtimeWiring;
            this.nodeParentTree = nodeParentTree;
            this.context = context;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        public RuntimeWiring getRuntimeWiring() {
            return this.runtimeWiring;
        }

        public NodeParentTree<NamedNode> getNodeParentTree() {
            return this.nodeParentTree;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }
    }
}

