/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.DirectiveRedefinitionError;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.idl.errors.SchemaRedefinitionError;
import graphql.schema.idl.errors.TypeRedefinitionError;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@PublicApi
public class TypeDefinitionRegistry {
    private final Map<String, List<ObjectTypeExtensionDefinition>> objectTypeExtensions = new LinkedHashMap<String, List<ObjectTypeExtensionDefinition>>();
    private final Map<String, List<InterfaceTypeExtensionDefinition>> interfaceTypeExtensions = new LinkedHashMap<String, List<InterfaceTypeExtensionDefinition>>();
    private final Map<String, List<UnionTypeExtensionDefinition>> unionTypeExtensions = new LinkedHashMap<String, List<UnionTypeExtensionDefinition>>();
    private final Map<String, List<EnumTypeExtensionDefinition>> enumTypeExtensions = new LinkedHashMap<String, List<EnumTypeExtensionDefinition>>();
    private final Map<String, List<ScalarTypeExtensionDefinition>> scalarTypeExtensions = new LinkedHashMap<String, List<ScalarTypeExtensionDefinition>>();
    private final Map<String, List<InputObjectTypeExtensionDefinition>> inputObjectTypeExtensions = new LinkedHashMap<String, List<InputObjectTypeExtensionDefinition>>();
    private final Map<String, TypeDefinition> types = new LinkedHashMap<String, TypeDefinition>();
    private final Map<String, ScalarTypeDefinition> scalarTypes = new LinkedHashMap<String, ScalarTypeDefinition>();
    private final Map<String, DirectiveDefinition> directiveDefinitions = new LinkedHashMap<String, DirectiveDefinition>();
    private SchemaDefinition schema;

    public TypeDefinitionRegistry merge(TypeDefinitionRegistry typeRegistry) throws SchemaProblem {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        LinkedHashMap tempTypes = new LinkedHashMap();
        typeRegistry.types.values().forEach(newEntry -> {
            Optional<GraphQLError> defined = this.define(this.types, tempTypes, newEntry);
            defined.ifPresent(errors::add);
        });
        LinkedHashMap tempDirectiveDefs = new LinkedHashMap();
        typeRegistry.directiveDefinitions.values().forEach(newEntry -> {
            Optional<GraphQLError> defined = this.define(this.directiveDefinitions, tempDirectiveDefs, newEntry);
            defined.ifPresent(errors::add);
        });
        LinkedHashMap tempScalarTypes = new LinkedHashMap();
        typeRegistry.scalarTypes.values().forEach(newEntry -> this.define(this.scalarTypes, tempScalarTypes, newEntry).ifPresent(errors::add));
        if (typeRegistry.schema != null && this.schema != null) {
            errors.add(new SchemaRedefinitionError(this.schema, typeRegistry.schema));
        }
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        if (this.schema == null) {
            this.schema = typeRegistry.schema;
        }
        this.types.putAll(tempTypes);
        this.scalarTypes.putAll(tempScalarTypes);
        this.directiveDefinitions.putAll(tempDirectiveDefs);
        typeRegistry.objectTypeExtensions.forEach((key, value) -> {
            List currentList = this.objectTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.interfaceTypeExtensions.forEach((key, value) -> {
            List currentList = this.interfaceTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.unionTypeExtensions.forEach((key, value) -> {
            List currentList = this.unionTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.enumTypeExtensions.forEach((key, value) -> {
            List currentList = this.enumTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.scalarTypeExtensions.forEach((key, value) -> {
            List currentList = this.scalarTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        typeRegistry.inputObjectTypeExtensions.forEach((key, value) -> {
            List currentList = this.inputObjectTypeExtensions.computeIfAbsent((String)key, k -> new ArrayList());
            currentList.addAll(value);
        });
        return this;
    }

    public Optional<GraphQLError> add(SDLDefinition definition) {
        SchemaDefinition newSchema;
        if (definition instanceof ObjectTypeExtensionDefinition) {
            ObjectTypeExtensionDefinition newEntry = (ObjectTypeExtensionDefinition)definition;
            return this.defineExt(this.objectTypeExtensions, newEntry, ObjectTypeDefinition::getName);
        }
        if (definition instanceof InterfaceTypeExtensionDefinition) {
            InterfaceTypeExtensionDefinition newEntry = (InterfaceTypeExtensionDefinition)definition;
            return this.defineExt(this.interfaceTypeExtensions, newEntry, InterfaceTypeDefinition::getName);
        }
        if (definition instanceof UnionTypeExtensionDefinition) {
            UnionTypeExtensionDefinition newEntry = (UnionTypeExtensionDefinition)definition;
            return this.defineExt(this.unionTypeExtensions, newEntry, UnionTypeDefinition::getName);
        }
        if (definition instanceof EnumTypeExtensionDefinition) {
            EnumTypeExtensionDefinition newEntry = (EnumTypeExtensionDefinition)definition;
            return this.defineExt(this.enumTypeExtensions, newEntry, EnumTypeDefinition::getName);
        }
        if (definition instanceof ScalarTypeExtensionDefinition) {
            ScalarTypeExtensionDefinition newEntry = (ScalarTypeExtensionDefinition)definition;
            return this.defineExt(this.scalarTypeExtensions, newEntry, ScalarTypeDefinition::getName);
        }
        if (definition instanceof InputObjectTypeExtensionDefinition) {
            InputObjectTypeExtensionDefinition newEntry = (InputObjectTypeExtensionDefinition)definition;
            return this.defineExt(this.inputObjectTypeExtensions, newEntry, InputObjectTypeDefinition::getName);
        }
        if (definition instanceof ScalarTypeDefinition) {
            ScalarTypeDefinition newEntry = (ScalarTypeDefinition)definition;
            return this.define(this.scalarTypes, this.scalarTypes, newEntry);
        }
        if (definition instanceof TypeDefinition) {
            TypeDefinition newEntry = (TypeDefinition)definition;
            return this.define(this.types, this.types, newEntry);
        }
        if (definition instanceof DirectiveDefinition) {
            DirectiveDefinition newEntry = (DirectiveDefinition)definition;
            return this.define(this.directiveDefinitions, this.directiveDefinitions, newEntry);
        }
        if (definition instanceof SchemaDefinition) {
            newSchema = (SchemaDefinition)definition;
            if (this.schema != null) {
                return Optional.of(new SchemaRedefinitionError(this.schema, newSchema));
            }
        } else {
            return (Optional)Assert.assertShouldNeverHappen();
        }
        this.schema = newSchema;
        return Optional.empty();
    }

    public void remove(SDLDefinition definition) {
        Assert.assertNotNull("definition to remove can't be null");
        if (definition instanceof ObjectTypeExtensionDefinition) {
            this.removeFromList(this.objectTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof InterfaceTypeExtensionDefinition) {
            this.removeFromList(this.interfaceTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof UnionTypeExtensionDefinition) {
            this.removeFromList(this.unionTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof EnumTypeExtensionDefinition) {
            this.removeFromList(this.enumTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof ScalarTypeExtensionDefinition) {
            this.removeFromList(this.scalarTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof InputObjectTypeExtensionDefinition) {
            this.removeFromList(this.inputObjectTypeExtensions, (TypeDefinition)definition);
        } else if (definition instanceof ScalarTypeDefinition) {
            this.scalarTypes.remove(((ScalarTypeDefinition)definition).getName());
        } else if (definition instanceof TypeDefinition) {
            this.types.remove(((TypeDefinition)definition).getName());
        } else if (definition instanceof DirectiveDefinition) {
            this.directiveDefinitions.remove(((DirectiveDefinition)definition).getName());
        } else if (definition instanceof SchemaDefinition) {
            this.schema = null;
        } else {
            Assert.assertShouldNeverHappen();
        }
    }

    private void removeFromList(Map source, TypeDefinition value) {
        List list = (List)source.get(value.getName());
        if (list == null) {
            return;
        }
        list.remove(value);
    }

    private <T extends TypeDefinition> Optional<GraphQLError> define(Map<String, T> source, Map<String, T> target, T newEntry) {
        String name = newEntry.getName();
        TypeDefinition olderEntry = (TypeDefinition)source.get(name);
        if (olderEntry != null) {
            return Optional.of(this.handleReDefinition(olderEntry, newEntry));
        }
        target.put(name, newEntry);
        return Optional.empty();
    }

    private <T extends DirectiveDefinition> Optional<GraphQLError> define(Map<String, T> source, Map<String, T> target, T newEntry) {
        String name = newEntry.getName();
        DirectiveDefinition olderEntry = (DirectiveDefinition)source.get(name);
        if (olderEntry != null) {
            return Optional.of(this.handleReDefinition(olderEntry, newEntry));
        }
        target.put(name, newEntry);
        return Optional.empty();
    }

    private <T> Optional<GraphQLError> defineExt(Map<String, List<T>> typeExtensions, T newEntry, Function<T, String> namerFunc) {
        List currentList = typeExtensions.computeIfAbsent(namerFunc.apply(newEntry), k -> new ArrayList());
        currentList.add(newEntry);
        return Optional.empty();
    }

    public Map<String, TypeDefinition> types() {
        return new LinkedHashMap<String, TypeDefinition>(this.types);
    }

    public Map<String, ScalarTypeDefinition> scalars() {
        LinkedHashMap<String, ScalarTypeDefinition> scalars = new LinkedHashMap<String, ScalarTypeDefinition>(ScalarInfo.STANDARD_SCALAR_DEFINITIONS);
        scalars.putAll(this.scalarTypes);
        return scalars;
    }

    public Map<String, List<ObjectTypeExtensionDefinition>> objectTypeExtensions() {
        return new LinkedHashMap<String, List<ObjectTypeExtensionDefinition>>(this.objectTypeExtensions);
    }

    public Map<String, List<InterfaceTypeExtensionDefinition>> interfaceTypeExtensions() {
        return new LinkedHashMap<String, List<InterfaceTypeExtensionDefinition>>(this.interfaceTypeExtensions);
    }

    public Map<String, List<UnionTypeExtensionDefinition>> unionTypeExtensions() {
        return new LinkedHashMap<String, List<UnionTypeExtensionDefinition>>(this.unionTypeExtensions);
    }

    public Map<String, List<EnumTypeExtensionDefinition>> enumTypeExtensions() {
        return new LinkedHashMap<String, List<EnumTypeExtensionDefinition>>(this.enumTypeExtensions);
    }

    public Map<String, List<ScalarTypeExtensionDefinition>> scalarTypeExtensions() {
        return new LinkedHashMap<String, List<ScalarTypeExtensionDefinition>>(this.scalarTypeExtensions);
    }

    public Map<String, List<InputObjectTypeExtensionDefinition>> inputObjectTypeExtensions() {
        return new LinkedHashMap<String, List<InputObjectTypeExtensionDefinition>>(this.inputObjectTypeExtensions);
    }

    public Optional<SchemaDefinition> schemaDefinition() {
        return Optional.ofNullable(this.schema);
    }

    private GraphQLError handleReDefinition(TypeDefinition oldEntry, TypeDefinition newEntry) {
        return new TypeRedefinitionError(newEntry, oldEntry);
    }

    private GraphQLError handleReDefinition(DirectiveDefinition oldEntry, DirectiveDefinition newEntry) {
        return new DirectiveRedefinitionError(newEntry, oldEntry);
    }

    public Optional<DirectiveDefinition> getDirectiveDefinition(String directiveName) {
        return Optional.ofNullable(this.directiveDefinitions.get(directiveName));
    }

    public Map<String, DirectiveDefinition> getDirectiveDefinitions() {
        return new LinkedHashMap<String, DirectiveDefinition>(this.directiveDefinitions);
    }

    public boolean hasType(TypeName typeName) {
        String name = typeName.getName();
        return this.types.containsKey(name) || ScalarInfo.STANDARD_SCALAR_DEFINITIONS.containsKey(name) || this.scalarTypes.containsKey(name) || this.objectTypeExtensions.containsKey(name);
    }

    public Optional<TypeDefinition> getType(Type type) {
        String typeName = TypeInfo.typeInfo(type).getName();
        return this.getType(typeName);
    }

    public <T extends TypeDefinition> Optional<T> getType(Type type, Class<T> ofType) {
        String typeName = TypeInfo.typeInfo(type).getName();
        return this.getType(typeName, ofType);
    }

    public Optional<TypeDefinition> getType(String typeName) {
        TypeDefinition typeDefinition = this.types.get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        typeDefinition = this.scalars().get(typeName);
        if (typeDefinition != null) {
            return Optional.of(typeDefinition);
        }
        return Optional.empty();
    }

    public <T extends TypeDefinition> Optional<T> getType(String typeName, Class<T> ofType) {
        TypeDefinition typeDefinition;
        Optional<TypeDefinition> type = this.getType(typeName);
        if (type.isPresent() && (typeDefinition = type.get()).getClass().equals(ofType)) {
            return Optional.of(typeDefinition);
        }
        return Optional.empty();
    }

    public boolean isInterfaceOrUnion(Type type) {
        Optional<TypeDefinition> typeDefinition = this.getType(type);
        if (typeDefinition.isPresent()) {
            TypeDefinition definition = typeDefinition.get();
            return definition instanceof UnionTypeDefinition || definition instanceof InterfaceTypeDefinition;
        }
        return false;
    }

    public boolean isObjectType(Type type) {
        return this.getType(type, ObjectTypeDefinition.class).isPresent();
    }

    public <T extends TypeDefinition> List<T> getTypes(Class<T> targetClass) {
        return this.types.values().stream().filter(targetClass::isInstance).map(targetClass::cast).collect(Collectors.toList());
    }

    public <T extends TypeDefinition> Map<String, T> getTypesMap(Class<T> targetClass) {
        List<T> list = this.getTypes(targetClass);
        return FpKit.getByName(list, TypeDefinition::getName, FpKit.mergeFirst());
    }

    public List<ObjectTypeDefinition> getImplementationsOf(InterfaceTypeDefinition targetInterface) {
        List<ObjectTypeDefinition> objectTypeDefinitions = this.getTypes(ObjectTypeDefinition.class);
        return objectTypeDefinitions.stream().filter(objectTypeDefinition -> {
            List<Type> implementsList = objectTypeDefinition.getImplements();
            for (Type iFace : implementsList) {
                boolean equals;
                Optional<InterfaceTypeDefinition> interfaceTypeDef = this.getType(iFace, InterfaceTypeDefinition.class);
                if (!interfaceTypeDef.isPresent() || !(equals = interfaceTypeDef.get().getName().equals(targetInterface.getName()))) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public boolean isPossibleType(Type abstractType, Type possibleObjectType) {
        if (!this.isInterfaceOrUnion(abstractType)) {
            return false;
        }
        if (!this.isObjectType(possibleObjectType)) {
            return false;
        }
        ObjectTypeDefinition targetObjectTypeDef = this.getType(possibleObjectType, ObjectTypeDefinition.class).get();
        TypeDefinition abstractTypeDef = this.getType(abstractType).get();
        if (abstractTypeDef instanceof UnionTypeDefinition) {
            List<Type> memberTypes = ((UnionTypeDefinition)abstractTypeDef).getMemberTypes();
            for (Type memberType : memberTypes) {
                Optional<ObjectTypeDefinition> checkType = this.getType(memberType, ObjectTypeDefinition.class);
                if (!checkType.isPresent() || !checkType.get().getName().equals(targetObjectTypeDef.getName())) continue;
                return true;
            }
            return false;
        }
        InterfaceTypeDefinition iFace = (InterfaceTypeDefinition)abstractTypeDef;
        List<ObjectTypeDefinition> objectTypeDefinitions = this.getImplementationsOf(iFace);
        return objectTypeDefinitions.stream().anyMatch(od -> od.getName().equals(targetObjectTypeDef.getName()));
    }

    public boolean isSubTypeOf(Type maybeSubType, Type superType) {
        TypeInfo superTypeInfo;
        TypeInfo maybeSubTypeInfo = TypeInfo.typeInfo(maybeSubType);
        if (maybeSubTypeInfo.equals(superTypeInfo = TypeInfo.typeInfo(superType))) {
            return true;
        }
        if (superTypeInfo.isNonNull()) {
            if (maybeSubTypeInfo.isNonNull()) {
                return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superTypeInfo.unwrapOneType());
            }
            return false;
        }
        if (maybeSubTypeInfo.isNonNull()) {
            return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superType);
        }
        if (superTypeInfo.isList()) {
            if (maybeSubTypeInfo.isList()) {
                return this.isSubTypeOf(maybeSubTypeInfo.unwrapOneType(), superTypeInfo.unwrapOneType());
            }
            return false;
        }
        if (maybeSubTypeInfo.isList()) {
            return false;
        }
        return this.isInterfaceOrUnion(superType) && this.isObjectType(maybeSubType) && this.isPossibleType(superType, maybeSubType);
    }
}

