/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.graph;

import java.awt.geom.Point2D;

public class ElectricCharge {

	private boolean moveable;
	private final Point2D position;
	private final double charge;

	public ElectricCharge(double x, double y, double charge) {
		this.position = new Point2D.Double(x, y);
		this.charge = charge;
	}

	public Point2D getPosition() {
		return position;
	}

	public double getCharge() {
		return charge;
	}

	public final boolean isMoveable() {
		return moveable;
	}

	public final void setMoveable(boolean moveable) {
		this.moveable = moveable;
	}

	public void move(double deltax, double deltay) {
		position.setLocation(position.getX() + deltax, position.getY() + deltay);
	}
}
