/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SortedCollectionArrayList<S extends Comparable<S>> implements SortedCollection<S> {

	private final List<S> allAsList = new ArrayList<S>();
	private final Set<S> allAsSet = new HashSet<S>();

	public Iterator<S> iterator() {
		return allAsList.iterator();
	}

	public void add(S newEntry) {
		final int r = Collections.binarySearch(allAsList, newEntry);
		if (r >= 0) {
			allAsList.add(r, newEntry);
		} else {
			allAsList.add(-1 - r, newEntry);
		}
		allAsSet.add(newEntry);
		assert isSorted();
	}

	public int size() {
		assert allAsSet.size() == allAsList.size();
		return allAsList.size();
	}

	List<S> toList() {
		return new ArrayList<S>(allAsList);
	}

	boolean isSorted() {
		S before = null;
		for (S ent : allAsList) {
			if (before != null && ent.compareTo(before) < 0) {
				return false;
			}
			before = ent;
		}
		return true;
	}

	public boolean contains(S entry) {
		return allAsSet.contains(entry);
	}

}
