/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.pdf;

import java.io.File;
import java.lang.reflect.Method;

public class PdfConverter {

	public static void convert(File svgFile, File pdfFile) {

		if (svgFile.exists() == false) {
			throw new IllegalArgumentException();
		}
		pdfFile.delete();
		if (pdfFile.exists()) {
			throw new IllegalStateException();
		}

		try {
			// https://stackoverflow.com/questions/12579468/how-to-set-log4j-property-file
			System.setProperty("log4j.debug", "false");

			final Class<?> clSVGConverter = Class.forName("org.apache.batik.apps.rasterizer.SVGConverter");

			final Object converter = clSVGConverter.newInstance();

			final Class<?> clDestinationType = Class.forName("org.apache.batik.apps.rasterizer.DestinationType");
			final Object pdf = clDestinationType.getField("PDF").get(null);
			final Method setDestinationType = clSVGConverter.getMethod("setDestinationType", clDestinationType);

			setDestinationType.invoke(converter, pdf);

			final String[] path = new String[] { svgFile.getAbsolutePath() };
			final Method setSources = clSVGConverter.getMethod("setSources", path.getClass());
			setSources.invoke(converter, new Object[] { path });
			final Method setDst = clSVGConverter.getMethod("setDst", pdfFile.getClass());
			setDst.invoke(converter, new Object[] { pdfFile });
			final Method execute = clSVGConverter.getMethod("execute");
			execute.invoke(converter);
		} catch (Exception e) {
			e.printStackTrace();
			throw new UnsupportedOperationException();
		}
		if (pdfFile.exists() == false) {
			throw new IllegalStateException();
		}
	}
}
