/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.preproc2;

import java.util.ArrayList;
import java.util.Collection;

import net.sourceforge.plantuml.preproc.ReadLine;

public class ReadFilterAnd2 implements ReadFilter {

	private final Collection<ReadFilter> all = new ArrayList<ReadFilter>();

	public void add(ReadFilter filter) {
		all.add(filter);
	}

	public ReadLine applyFilter(ReadLine current) {
		for (ReadFilter f : all) {
			current = f.applyFilter(current);
		}
		return current;
		// if (filter3 == null && filter4 == null) {
		// return filter2.applyFilter(filter1.applyFilter(source));
		// }
		// if (filter4 == null) {
		// return filter3.applyFilter(filter2.applyFilter(filter1.applyFilter(source)));
		// }
		// return filter4.applyFilter(filter3.applyFilter(filter2.applyFilter(filter1.applyFilter(source))));
	}

}
