/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.preproc.ReadLine;

public abstract class ReadLineInsertable implements ReadLine {

	private final List<ReadLine> sources = new ArrayList<ReadLine>();

	final protected void insert(ReadLine inserted) throws IOException {
		sources.add(0, inserted);
	}

	abstract CharSequence2 readLineInternal() throws IOException;

	final public CharSequence2 readLine() throws IOException {
		while (sources.size() > 0) {
			final ReadLine tmp = sources.get(0);
			final CharSequence2 result = tmp.readLine();
			if (result != null) {
				return result;
			}
			tmp.close();
			sources.remove(0);
		}
		return readLineInternal();
	}

	abstract void closeInternal() throws IOException;

	final public void close() throws IOException {
		for (ReadLine s : sources) {
			s.close();
		}
		closeInternal();
	}

}
