/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxFinder implements UGraphic {

	public boolean matchesProperty(String propertyName) {
		return false;
	}
	
	public double dpiFactor() {
		return 1;
	}


	public UGraphic apply(UChange change) {
		if (change instanceof UTranslate) {
			return new LiveBoxFinder(stringBounder, translate.compose((UTranslate) change));
		} else if (change instanceof UStroke) {
			return new LiveBoxFinder(this);
		} else if (change instanceof UChangeBackColor) {
			return new LiveBoxFinder(this);
		} else if (change instanceof UChangeColor) {
			return new LiveBoxFinder(this);
		}
		throw new UnsupportedOperationException();
	}

	private final StringBounder stringBounder;
	private final UTranslate translate;

	public LiveBoxFinder(StringBounder stringBounder) {
		this(stringBounder, new UTranslate());
	}

	private LiveBoxFinder(StringBounder stringBounder, UTranslate translate) {
		this.stringBounder = stringBounder;
		this.translate = translate;
	}

	private LiveBoxFinder(LiveBoxFinder other) {
		this(other.stringBounder, other.translate);
	}

	public StringBounder getStringBounder() {
		return stringBounder;
	}

	public UParam getParam() {
		return new UParamNull();
	}

	public void draw(UShape shape) {
		final double x = translate.getDx();
		final double y = translate.getDy();
		if (shape instanceof GroupingTile) {
			((GroupingTile) shape).drawU(this);
		} else if (shape instanceof TileWithUpdateStairs) {
			((TileWithUpdateStairs) shape).updateStairs(stringBounder, y);
		} else if (shape instanceof EmptyTile) {
			// Nothing ?
		} else if (shape instanceof TileParallel) {
			// Nothing ?
		} else if (shape instanceof NotesTile) {
			// Nothing ?
		} else if (shape instanceof Tile) {
			Log.info("OtherTile " + shape);
		} else {
			throw new UnsupportedOperationException(shape.getClass().getName());
		}
	}

	public ColorMapper getColorMapper() {
		return new ColorMapperIdentity();
	}

	public void startUrl(Url url) {
	}

	public void closeAction() {
	}

	public void flushUg() {
	}

}
