/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ChangeState implements Comparable<ChangeState> {

	private final TimeTick when;
	private final String state;
	private final String comment;
	private final Colors colors;

	public ChangeState(TimeTick when, String state, String comment, Colors colors) {
		this.when = when;
		this.state = state;
		this.comment = comment;
		this.colors = colors;
	}

	public int compareTo(ChangeState other) {
		return this.when.compareTo(other.when);
	}

	public final TimeTick getWhen() {
		return when;
	}

	public final String getState() {
		return state;
	}

	public String getComment() {
		return comment;
	}

	private final HtmlColor getBackColor() {
		if (colors == null || colors.getColor(ColorType.BACK) == null) {
			return HtmlColorUtils.COL_D7E0F2;
		}
		return colors.getColor(ColorType.BACK);
	}

	private final HtmlColor getLineColor() {
		if (colors == null || colors.getColor(ColorType.LINE) == null) {
			return HtmlColorUtils.COL_038048;
		}
		return colors.getColor(ColorType.LINE);
	}

	public SymbolContext getContext() {
		return new SymbolContext(getBackColor(), getLineColor()).withStroke(new UStroke(1.5));
	}

	public final boolean isBlank() {
		return state.equals("{...}");
	}

	public final boolean isCompletelyHidden() {
		return state.equals("{hidden}");
	}

}
