/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2020, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * If you like this project or if you find it useful, you can support us at:
 * 
 * http://plantuml.com/patreon (only 1$ per month!)
 * http://plantuml.com/paypal
 * 
 * This file is part of PlantUML.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [Eclipse Public License - v 1.0]
 * 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 * 
 * You may obtain a copy of the License at
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;

import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;

public class TimeTickBuilder {

	private static final String WITHOUT_AROBASE = "(\\+?)(-?\\d+\\.?\\d*)";
	private static final String WITH_AROBASE = "@" + WITHOUT_AROBASE;

	public static RegexLeaf expressionAtWithoutArobase(String name) {
		return new RegexLeaf(name, WITHOUT_AROBASE);
	}

	public static RegexLeaf expressionAtWithArobase(String name) {
		return new RegexLeaf(name, WITH_AROBASE);
	}

	public static RegexLeaf optionalExpressionAtWithArobase(String name) {
		return new RegexLeaf(name, "(?:" + WITH_AROBASE + ")?");
	}

	public static TimeTick parseTimeTick(String name, RegexResult arg, Clock clock) {
		final String number = arg.get(name, 1);
		if (number == null) {
			return clock.getNow();
		}
		final boolean isRelative = "+".equals(arg.get(name, 0));
		BigDecimal value = new BigDecimal(number);
		if (isRelative) {
			value = clock.getNow().getTime().add(value);
		}
		return new TimeTick(value);
	}

}
