/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final double margin = 5.0;
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor maincolor;
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;

    public static IEntityImage createForError(List<String> strings, boolean useRed) {
        if (useRed) {
            return new GraphicStrings(strings, UFont.sansSerif(14).bold(), HtmlColorUtils.BLACK, HtmlColorUtils.RED_LIGHT, null, null);
        }
        return new GraphicStrings(strings, UFont.sansSerif(14).bold(), HtmlColorSet.getInstance().getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, null, null);
    }

    public static TextBlockBackcolored createGreenOnBlackMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(), HtmlColorUtils.GREEN, HtmlColorUtils.BLACK, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhiteMonospaced(List<String> strings) {
        return new GraphicStrings(strings, GraphicStrings.monospaced14(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> strings, BufferedImage image, GraphicPosition position) {
        return new GraphicStrings(strings, GraphicStrings.sansSerif12(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, image, position);
    }

    private static UFont sansSerif12() {
        return UFont.sansSerif(12);
    }

    private static UFont monospaced14() {
        return UFont.monospaced(14);
    }

    private GraphicStrings(List<String> strings, UFont font, HtmlColor maincolor, HtmlColor background, BufferedImage image, GraphicPosition position) {
        this.strings = strings;
        this.font = font;
        this.maincolor = maincolor;
        this.background = background;
        this.image = image;
        this.position = position;
    }

    private TextBlock getTextBlock() {
        TextBlock result = null;
        result = Display.create(this.strings).create(new FontConfiguration(this.font, this.maincolor, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        Dimension2D size = this.calculateDimensionInternal(ug.getStringBounder());
        this.getTextBlock().drawU(ug.apply(new UChangeColor(this.maincolor)));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                ug.apply(new UTranslate((size.getWidth() - (double)this.image.getWidth()) / 2.0, size.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth(), size.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(this.image));
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.calculateDimensionInternal(stringBounder), 10.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dim = this.getTextBlock().calculateDimension(stringBounder);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dim = new Dimension2DDouble(dim.getWidth(), dim.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + (double)this.image.getWidth(), dim.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + (double)this.image.getWidth(), dim.getHeight());
            }
        }
        return dim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.background;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

