/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Color;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.ColorChangerMonochrome;

public class HtmlColorSimple
implements HtmlColor {
    private final Color color;
    private final boolean monochrome;

    public int hashCode() {
        return this.color.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof HtmlColorSimple)) {
            return false;
        }
        return this.color.equals(((HtmlColorSimple)other).color);
    }

    public HtmlColorSimple(Color c, boolean monochrome) {
        this.color = c;
        this.monochrome = monochrome;
    }

    public Color getColor999() {
        return this.color;
    }

    public HtmlColorSimple asMonochrome() {
        if (this.monochrome) {
            throw new IllegalStateException();
        }
        return new HtmlColorSimple(new ColorChangerMonochrome().getChangedColor(this.color), true);
    }

    public HtmlColorSimple opposite() {
        Color mono = new ColorChangerMonochrome().getChangedColor(this.color);
        int grayScale = 255 - mono.getGreen() > 127 ? 255 : 0;
        return new HtmlColorSimple(new Color(grayScale, grayScale, grayScale), true);
    }

    public double distance(HtmlColorSimple other) {
        int diffRed = Math.abs(this.color.getRed() - other.color.getRed());
        int diffGreen = Math.abs(this.color.getGreen() - other.color.getGreen());
        int diffBlue = Math.abs(this.color.getBlue() - other.color.getBlue());
        return (double)diffRed * 0.3 + (double)diffGreen * 0.59 + (double)diffBlue * 0.11;
    }
}

