/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.IfManagerFilter;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineNumbered;
import net.sourceforge.plantuml.preproc2.PreprocessorDefine3Learner;
import net.sourceforge.plantuml.preproc2.PreprocessorDefine4Apply;
import net.sourceforge.plantuml.preproc2.PreprocessorInclude3;
import net.sourceforge.plantuml.preproc2.ReadFilterAnd2;
import net.sourceforge.plantuml.preproc2.ReadLineAddConfig2;
import net.sourceforge.plantuml.preproc2.ReadLineQuoteComment2;
import net.sourceforge.plantuml.preproc2.SubPreprocessor2;

public class Preprocessor2
implements ReadLineNumbered {
    private final ReadLine source;
    private final PreprocessorInclude3 include;

    public Preprocessor2(List<String> config, ReadLine reader, String charset, Defines defines, DefinitionsContainer definitionsContainer, ImportedFiles importedFiles) throws IOException {
        this(config, reader, charset, new DefinesGet(defines), definitionsContainer, new HashSet<FileWithSuffix>(), importedFiles, true);
    }

    Preprocessor2(List<String> config, ReadLine reader, String charset, DefinesGet defines, DefinitionsContainer definitionsContainer, Set<FileWithSuffix> filesUsedGlobal, ImportedFiles importedFiles, boolean doSaveState) throws IOException {
        ReadFilterAnd2 filters = new ReadFilterAnd2();
        if (doSaveState) {
            defines.saveState();
        }
        filters.add(new ReadLineQuoteComment2());
        this.include = new PreprocessorInclude3(config, charset, defines, definitionsContainer, importedFiles, filesUsedGlobal);
        filters.add(new ReadLineAddConfig2(config));
        filters.add(new IfManagerFilter(defines));
        filters.add(new PreprocessorDefine4Apply(defines));
        filters.add(new SubPreprocessor2(charset, definitionsContainer));
        filters.add(new PreprocessorDefine3Learner(defines, importedFiles.getCurrentDir()));
        filters.add(this.include);
        this.source = filters.applyFilter(reader);
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        return this.source.readLine();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public Set<FileWithSuffix> getFilesUsed() {
        return Collections.unmodifiableSet(this.include.getFilesUsedGlobal());
    }
}

