/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private final TextBlockBackcolored graphicStrings;
    private final BufferedImage flashCode;
    private final String text;

    public GraphvizCrash(String text) {
        this.text = text;
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        this.flashCode = utils.exportFlashcode(text, Color.BLACK, Color.WHITE);
        this.graphicStrings = GraphicStrings.createBlackOnWhite(this.init(), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    public static List<String> anErrorHasOccured(Throwable exception, String text) {
        ArrayList<String> strings = new ArrayList<String>();
        if (exception == null) {
            strings.add("An error has occured!");
        } else {
            strings.add("An error has occured : " + exception);
        }
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("Diagram size: " + GraphvizCrash.lines(text) + " lines / " + text.length() + " characters.");
        strings.add(" ");
        return strings;
    }

    private static int lines(String text) {
        int result = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    public static void checkOldVersionWarning(List<String> strings) {
        long days = (System.currentTimeMillis() - Version.compileTime()) / 1000L / 3600L / 24L;
        if (days >= 90L) {
            strings.add("This version of PlantUML is " + days + " days old, so you should");
            strings.add("  consider upgrading from http://plantuml.com/download");
        }
    }

    public static void pleaseGoTo(List<String> strings) {
        strings.add(" ");
        strings.add("Please go to http://plantuml.com/graphviz-dot to check your GraphViz version.");
        strings.add(" ");
    }

    public static void youShouldSendThisDiagram(List<String> strings) {
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>http://plantuml.com/qa</b> to solve this issue.");
        strings.add("You can try to turn arround this issue by simplifing your diagram.");
    }

    public static void thisMayBeCaused(List<String> strings) {
        strings.add("This may be caused by :");
        strings.add(" - a bug in PlantUML");
        strings.add(" - a problem in GraphViz");
    }

    private List<String> init() {
        List<String> strings = GraphvizCrash.anErrorHasOccured(null, this.text);
        strings.add("For some reason, dot/Graphviz has crashed.");
        strings.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        GraphvizCrash.checkOldVersionWarning(strings);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        try {
            String dotVersion = GraphvizUtils.dotVersion();
            strings.add("Default dot version: " + dotVersion);
        }
        catch (Throwable e) {
            strings.add("Cannot determine dot version: " + e.toString());
        }
        GraphvizCrash.pleaseGoTo(strings);
        GraphvizCrash.youShouldSendThisDiagram(strings);
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        return strings;
    }

    public static void addDecodeHint(List<String> strings) {
        strings.add(" ");
        strings.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the qrcode)");
    }

    public static void addProperties(List<String> strings) {
        strings.addAll(OptionPrint.interestingProperties());
        strings.addAll(OptionPrint.interestingValues());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HtmlColor getBackcolor() {
        return HtmlColorUtils.WHITE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = this.graphicStrings.calculateDimension(stringBounder);
        if (this.flashCode != null) {
            result = Dimension2DDouble.mergeTB(result, new Dimension2DDouble(this.flashCode.getWidth(), this.flashCode.getHeight()));
        }
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.graphicStrings.drawU(ug);
        if (this.flashCode != null) {
            double h = this.graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
            ug = ug.apply(new UTranslate(0.0, h));
            ug.draw(new UImage(this.flashCode).scaleNearestNeighbor(3.0));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

