/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class VolumeAttachment {
    private final String id;
    @Named(value="volume_id")
    private final String volumeId;
    @Named(value="server_id")
    private final String serverId;
    private final String device;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVolumeAttachment(this);
    }

    @ConstructorProperties(value={"id", "volume_id", "server_id", "device"})
    protected VolumeAttachment(String id, String volumeId, @Nullable String serverId, @Nullable String device) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.volumeId = (String)Preconditions.checkNotNull((Object)volumeId, (Object)"volumeId");
        this.serverId = serverId;
        this.device = device;
    }

    public String getId() {
        return this.id;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    @Nullable
    public String getServerId() {
        return this.serverId;
    }

    @Nullable
    public String getDevice() {
        return this.device;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.volumeId, this.serverId, this.device});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeAttachment that = (VolumeAttachment)VolumeAttachment.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.volumeId, (Object)that.volumeId) && Objects.equal((Object)this.serverId, (Object)that.serverId) && Objects.equal((Object)this.device, (Object)that.device);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("volumeId", (Object)this.volumeId).add("serverId", (Object)this.serverId).add("device", (Object)this.device);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String volumeId;
        protected String serverId;
        protected String device;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this.self();
        }

        public T serverId(String serverId) {
            this.serverId = serverId;
            return this.self();
        }

        public T device(String device) {
            this.device = device;
            return this.self();
        }

        public VolumeAttachment build() {
            return new VolumeAttachment(this.id, this.volumeId, this.serverId, this.device);
        }

        public T fromVolumeAttachment(VolumeAttachment in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).volumeId(in.getVolumeId())).serverId(in.getServerId())).device(in.getDevice());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

