/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.options.ListContainerOptions;
import org.jclouds.docker.options.RemoveContainerOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class DockerComputeServiceAdapter
implements ComputeServiceAdapter<Container, Hardware, Image, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DockerApi api;

    @Inject
    public DockerComputeServiceAdapter(DockerApi api) {
        this.api = (DockerApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Container> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template was null");
        Preconditions.checkNotNull((Object)template.getOptions(), (Object)"template options was null");
        String imageId = (String)Preconditions.checkNotNull((Object)template.getImage().getId(), (Object)"template image id must not be null");
        String loginUser = template.getImage().getDefaultCredentials().getUser();
        String loginUserPassword = template.getImage().getDefaultCredentials().getPassword();
        DockerTemplateOptions templateOptions = (DockerTemplateOptions)DockerTemplateOptions.class.cast(template.getOptions());
        int[] inboundPorts = templateOptions.getInboundPorts();
        HashMap exposedPorts = Maps.newHashMap();
        for (int inboundPort : inboundPorts) {
            exposedPorts.put(inboundPort + "/tcp", Maps.newHashMap());
        }
        Config.Builder containerConfigBuilder = Config.builder().imageId(imageId).exposedPorts(exposedPorts);
        if (templateOptions.getCommands().isPresent()) {
            containerConfigBuilder.cmd((List)templateOptions.getCommands().get());
        }
        if (templateOptions.getMemory().isPresent()) {
            containerConfigBuilder.memory((Integer)templateOptions.getMemory().get());
        }
        if (templateOptions.getCpuShares().isPresent()) {
            containerConfigBuilder.cpuShares((Integer)templateOptions.getCpuShares().get());
        }
        if (templateOptions.getVolumes().isPresent()) {
            LinkedHashMap volumes = Maps.newLinkedHashMap();
            for (String containerDir : ((Map)templateOptions.getVolumes().get()).values()) {
                volumes.put(containerDir, Maps.newHashMap());
            }
            containerConfigBuilder.volumes(volumes);
        }
        Config containerConfig = containerConfigBuilder.build();
        this.logger.debug(">> creating new container with containerConfig(%s)", new Object[]{containerConfig});
        Container container = this.api.getRemoteApi().createContainer(name, containerConfig);
        this.logger.trace("<< container(%s)", new Object[]{container.getId()});
        HostConfig.Builder hostConfigBuilder = HostConfig.builder().publishAllPorts(true).privileged(true);
        if (templateOptions.getDns().isPresent()) {
            hostConfigBuilder.dns((String)templateOptions.getDns().get());
        }
        if (templateOptions.getVolumes().isPresent()) {
            for (Map.Entry entry : ((Map)templateOptions.getVolumes().get()).entrySet()) {
                hostConfigBuilder.binds((List<String>)ImmutableList.of((Object)((String)entry.getKey() + ":" + (String)entry.getValue())));
            }
        }
        HostConfig hostConfig = hostConfigBuilder.build();
        this.api.getRemoteApi().startContainer(container.getId(), hostConfig);
        container = this.api.getRemoteApi().inspectContainer(container.getId());
        if (container.getState().getExitCode() != 0) {
            this.destroyNode(container.getId());
            throw new IllegalStateException(String.format("Container %s has not started correctly", container.getId()));
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)container, container.getId(), LoginCredentials.builder().user(loginUser).password(loginUserPassword).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        LinkedHashSet hardware = Sets.newLinkedHashSet();
        hardware.add(new HardwareBuilder().ids("micro").hypervisor("lxc").name("micro").processor(new Processor(1.0, 1.0)).ram(512).build());
        hardware.add(new HardwareBuilder().ids("small").hypervisor("lxc").name("small").processor(new Processor(1.0, 1.0)).ram(1024).build());
        hardware.add(new HardwareBuilder().ids("medium").hypervisor("lxc").name("medium").processor(new Processor(1.0, 1.0)).ram(2048).build());
        hardware.add(new HardwareBuilder().ids("large").hypervisor("lxc").name("large").processor(new Processor(1.0, 1.0)).ram(3072).build());
        return hardware;
    }

    public Set<Image> listImages() {
        HashSet images = Sets.newHashSet();
        for (Image image : this.api.getRemoteApi().listImages()) {
            Image inspected = this.api.getRemoteApi().inspectImage(image.getId());
            if (inspected.getRepoTags().isEmpty()) {
                inspected = Image.builder().fromImage(inspected).repoTags(image.getRepoTags()).build();
            }
            images.add(inspected);
        }
        return images;
    }

    public Image getImage(final String imageId) {
        return (Image)Iterables.find((Iterable)this.listImages(), (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return input.getId().equals(imageId);
            }
        }, null);
    }

    public Iterable<Container> listNodes() {
        HashSet containers = Sets.newHashSet();
        for (Container container : this.api.getRemoteApi().listContainers(ListContainerOptions.Builder.all(true))) {
            containers.add(this.api.getRemoteApi().inspectContainer(container.getId()));
        }
        return containers;
    }

    public Iterable<Container> listNodesByIds(Iterable<String> ids) {
        HashSet containers = Sets.newHashSet();
        for (String id : ids) {
            containers.add(this.api.getRemoteApi().inspectContainer(id));
        }
        return containers;
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public Container getNode(String id) {
        return this.api.getRemoteApi().inspectContainer(id);
    }

    public void destroyNode(String id) {
        this.api.getRemoteApi().removeContainer(id, RemoveContainerOptions.Builder.force(true));
    }

    public void rebootNode(String id) {
        this.api.getRemoteApi().stopContainer(id);
        this.api.getRemoteApi().startContainer(id);
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException("resume not supported");
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

