/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class Config {
    @SerializedName(value="Hostname")
    private final String hostname;
    @SerializedName(value="Domainname")
    private final String domainName;
    @SerializedName(value="User")
    private final String user;
    @SerializedName(value="Memory")
    private final int memory;
    @SerializedName(value="MemorySwap")
    private final int memorySwap;
    @SerializedName(value="CpuShares")
    private final int cpuShares;
    @SerializedName(value="AttachStdin")
    private final boolean attachStdin;
    @SerializedName(value="AttachStdout")
    private final boolean attachStdout;
    @SerializedName(value="AttachStderr")
    private final boolean attachStderr;
    @SerializedName(value="ExposedPorts")
    private final Map<String, ?> exposedPorts;
    @SerializedName(value="Tty")
    private final boolean tty;
    @SerializedName(value="OpenStdin")
    private final boolean openStdin;
    @SerializedName(value="StdinOnce")
    private final boolean stdinOnce;
    @SerializedName(value="Env")
    private final List<String> env;
    @SerializedName(value="Cmd")
    private final List<String> cmd;
    @SerializedName(value="Dns")
    private final List<String> dns;
    @SerializedName(value="Image")
    private final String imageId;
    @SerializedName(value="Volumes")
    private final Map<String, ?> volumes;
    @SerializedName(value="VolumesFrom")
    private final String volumesFrom;
    @SerializedName(value="WorkingDir")
    private final String workingDir;
    @SerializedName(value="Entrypoint")
    private final String entrypoint;
    @SerializedName(value="NetworkDisabled")
    private final boolean networkDisabled;
    @SerializedName(value="OnBuild")
    private final List<String> onBuild;

    @ConstructorProperties(value={"Hostname", "Domainname", "User", "Memory", "MemorySwap", "CpuShares", "AttachStdin", "AttachStdout", "AttachStderr", "ExposedPorts", "Tty", "OpenStdin", "StdinOnce", "Env", "Cmd", "Dns", "Image", "Volumes", "VolumesFrom", "WorkingDir", "Entrypoint", "NetworkDisabled", "OnBuild"})
    protected Config(@Nullable String hostname, @Nullable String domainName, @Nullable String user, int memory, int memorySwap, int cpuShares, boolean attachStdin, boolean attachStdout, boolean attachStderr, Map<String, ?> exposedPorts, boolean tty, boolean openStdin, boolean stdinOnce, @Nullable List<String> env, @Nullable List<String> cmd, @Nullable List<String> dns, String imageId, @Nullable Map<String, ?> volumes, @Nullable String volumesFrom, @Nullable String workingDir, @Nullable String entrypoint, @Nullable boolean networkDisabled, @Nullable List<String> onBuild) {
        this.hostname = hostname;
        this.domainName = domainName;
        this.user = user;
        this.memory = (Integer)Preconditions.checkNotNull((Object)memory, (Object)"memory");
        this.memorySwap = (Integer)Preconditions.checkNotNull((Object)memorySwap, (Object)"memorySwap");
        this.cpuShares = (Integer)Preconditions.checkNotNull((Object)cpuShares, (Object)"cpuShares");
        this.attachStdin = (Boolean)Preconditions.checkNotNull((Object)attachStdin, (Object)"attachStdin");
        this.attachStdout = (Boolean)Preconditions.checkNotNull((Object)attachStdout, (Object)"attachStdout");
        this.attachStderr = (Boolean)Preconditions.checkNotNull((Object)attachStderr, (Object)"attachStderr");
        this.exposedPorts = exposedPorts != null ? ImmutableMap.copyOf(exposedPorts) : ImmutableMap.of();
        this.tty = (Boolean)Preconditions.checkNotNull((Object)tty, (Object)"tty");
        this.openStdin = (Boolean)Preconditions.checkNotNull((Object)openStdin, (Object)"openStdin");
        this.stdinOnce = (Boolean)Preconditions.checkNotNull((Object)stdinOnce, (Object)"stdinOnce");
        this.env = env != null ? ImmutableList.copyOf(env) : ImmutableList.of();
        this.cmd = cmd != null ? ImmutableList.copyOf(cmd) : ImmutableList.of();
        this.dns = dns != null ? ImmutableList.copyOf(dns) : ImmutableList.of();
        this.imageId = (String)Preconditions.checkNotNull((Object)imageId, (Object)"imageId");
        this.volumes = volumes != null ? ImmutableMap.copyOf(volumes) : ImmutableMap.of();
        this.volumesFrom = volumesFrom;
        this.workingDir = workingDir;
        this.entrypoint = entrypoint;
        this.networkDisabled = networkDisabled;
        this.onBuild = onBuild != null ? ImmutableList.copyOf(onBuild) : ImmutableList.of();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getUser() {
        return this.user;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getMemorySwap() {
        return this.memorySwap;
    }

    public int getCpuShares() {
        return this.cpuShares;
    }

    public boolean isAttachStdin() {
        return this.attachStdin;
    }

    public boolean isAttachStdout() {
        return this.attachStdout;
    }

    public boolean isAttachStderr() {
        return this.attachStderr;
    }

    public Map<String, ?> getExposedPorts() {
        return this.exposedPorts;
    }

    public boolean isTty() {
        return this.tty;
    }

    public boolean isOpenStdin() {
        return this.openStdin;
    }

    public boolean isStdinOnce() {
        return this.stdinOnce;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Map<String, ?> getVolumes() {
        return this.volumes;
    }

    public String getVolumesFrom() {
        return this.volumesFrom;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    public List<String> getOnBuild() {
        return this.onBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config that = (Config)o;
        return Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.domainName, (Object)that.domainName) && Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.memory, (Object)that.memory) && Objects.equal((Object)this.memorySwap, (Object)that.memorySwap) && Objects.equal((Object)this.cpuShares, (Object)that.cpuShares) && Objects.equal((Object)this.attachStdin, (Object)that.attachStdin) && Objects.equal((Object)this.attachStdout, (Object)that.attachStdout) && Objects.equal((Object)this.attachStderr, (Object)that.attachStderr) && Objects.equal(this.exposedPorts, that.exposedPorts) && Objects.equal((Object)this.tty, (Object)that.tty) && Objects.equal((Object)this.openStdin, (Object)that.openStdin) && Objects.equal((Object)this.stdinOnce, (Object)that.stdinOnce) && Objects.equal(this.env, that.env) && Objects.equal(this.cmd, that.cmd) && Objects.equal(this.dns, that.dns) && Objects.equal((Object)this.imageId, (Object)that.imageId) && Objects.equal(this.volumes, that.volumes) && Objects.equal((Object)this.volumesFrom, (Object)that.volumesFrom) && Objects.equal((Object)this.workingDir, (Object)that.workingDir) && Objects.equal((Object)this.entrypoint, (Object)that.entrypoint) && Objects.equal(this.onBuild, that.onBuild);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostname, this.domainName, this.user, this.memory, this.memorySwap, this.cpuShares, this.attachStdin, this.attachStdout, this.attachStderr, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.dns, this.imageId, this.volumes, this.volumesFrom, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("domainName", (Object)this.domainName).add("user", (Object)this.user).add("memory", this.memory).add("memorySwap", this.memorySwap).add("cpuShares", this.cpuShares).add("attachStdin", this.attachStdin).add("attachStdout", this.attachStdout).add("attachStderr", this.attachStderr).add("exposedPorts", this.exposedPorts).add("tty", this.tty).add("openStdin", this.openStdin).add("stdinOnce", this.stdinOnce).add("env", this.env).add("cmd", this.cmd).add("dns", this.dns).add("imageId", (Object)this.imageId).add("volumes", this.volumes).add("volumesFrom", (Object)this.volumesFrom).add("workingDir", (Object)this.workingDir).add("entrypoint", (Object)this.entrypoint).add("networkDisabled", this.networkDisabled).add("onBuild", this.onBuild).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Config.builder().fromConfig(this);
    }

    public static final class Builder {
        private String hostname;
        private String domainName;
        private String user;
        private int memory;
        private int memorySwap;
        private int cpuShares;
        private boolean attachStdin;
        private boolean attachStdout;
        private boolean attachStderr;
        private Map<String, ?> exposedPorts = ImmutableMap.of();
        private boolean tty;
        private boolean openStdin;
        private boolean stdinOnce;
        private List<String> env = ImmutableList.of();
        private List<String> cmd = ImmutableList.of();
        private List<String> dns = ImmutableList.of();
        private String imageId;
        private Map<String, ?> volumes = ImmutableMap.of();
        private String volumesFrom;
        private String workingDir;
        private String entrypoint;
        private boolean networkDisabled;
        private List<String> onBuild = ImmutableList.of();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder memory(int memory) {
            this.memory = memory;
            return this;
        }

        public Builder memorySwap(int memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Builder cpuShares(int cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Builder attachStdin(boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        public Builder attachStdout(boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        public Builder attachStderr(boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public Builder exposedPorts(Map<String, ?> exposedPorts) {
            this.exposedPorts = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(exposedPorts, (Object)"exposedPorts")));
            return this;
        }

        public Builder tty(boolean tty) {
            this.tty = tty;
            return this;
        }

        public Builder openStdin(boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        public Builder stdinOnce(boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public Builder env(List<String> env) {
            this.env = env;
            return this;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(cmd, (Object)"cmd")));
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(dns, (Object)"dns")));
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder volumes(Map<String, ?> volumes) {
            this.volumes = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(volumes, (Object)"volumes")));
            return this;
        }

        public Builder volumesFrom(String volumesFrom) {
            this.volumesFrom = volumesFrom;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public Builder entrypoint(String entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public Builder networkDisabled(boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public Builder onBuild(List<String> onBuild) {
            this.onBuild = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(onBuild, (Object)"onBuild")));
            return this;
        }

        public Config build() {
            return new Config(this.hostname, this.domainName, this.user, this.memory, this.memorySwap, this.cpuShares, this.attachStdin, this.attachStdout, this.attachStderr, this.exposedPorts, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.dns, this.imageId, this.volumes, this.volumesFrom, this.workingDir, this.entrypoint, this.networkDisabled, this.onBuild);
        }

        public Builder fromConfig(Config in) {
            return this.hostname(in.getHostname()).domainName(in.getDomainName()).user(in.getUser()).memory(in.getMemory()).memorySwap(in.getMemorySwap()).cpuShares(in.getCpuShares()).attachStdin(in.isAttachStdin()).attachStdout(in.isAttachStdout()).attachStderr(in.isAttachStderr()).exposedPorts(in.getExposedPorts()).tty(in.isTty()).openStdin(in.isOpenStdin()).stdinOnce(in.isStdinOnce()).env(in.getEnv()).cmd(in.getCmd()).dns(in.getDns()).imageId(in.getImageId()).volumes(in.getVolumes()).volumesFrom(in.getVolumesFrom()).workingDir(in.getWorkingDir()).entrypoint(in.getEntrypoint()).networkDisabled(in.isNetworkDisabled()).onBuild(in.getOnBuild());
        }
    }
}

