/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class NetworkSettings {
    @SerializedName(value="IPAddress")
    private final String ipAddress;
    @SerializedName(value="IPPrefixLen")
    private final int ipPrefixLen;
    @SerializedName(value="Gateway")
    private final String gateway;
    @SerializedName(value="Bridge")
    private final String bridge;
    @SerializedName(value="PortMapping")
    private final String portMapping;
    @SerializedName(value="Ports")
    private final Map<String, List<Map<String, String>>> ports;

    @ConstructorProperties(value={"IPAddress", "IPPrefixLen", "Gateway", "Bridge", "PortMapping", "Ports"})
    protected NetworkSettings(String ipAddress, int ipPrefixLen, String gateway, String bridge, @Nullable String portMapping, @Nullable Map<String, List<Map<String, String>>> ports) {
        this.ipAddress = (String)Preconditions.checkNotNull((Object)ipAddress, (Object)"ipAddress");
        this.ipPrefixLen = (Integer)Preconditions.checkNotNull((Object)ipPrefixLen, (Object)"ipPrefixLen");
        this.gateway = (String)Preconditions.checkNotNull((Object)gateway, (Object)"gateway");
        this.bridge = (String)Preconditions.checkNotNull((Object)bridge, (Object)"bridge");
        this.portMapping = portMapping;
        this.ports = ports != null ? ImmutableMap.copyOf(ports) : ImmutableMap.of();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getBridge() {
        return this.bridge;
    }

    public String getPortMapping() {
        return this.portMapping;
    }

    public Map<String, List<Map<String, String>>> getPorts() {
        return this.ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSettings that = (NetworkSettings)o;
        return Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.ipPrefixLen, (Object)that.ipPrefixLen) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.bridge, (Object)that.bridge) && Objects.equal((Object)this.portMapping, (Object)that.portMapping) && Objects.equal(this.ports, that.ports);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.ports});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("ipAddress", (Object)this.ipAddress).add("ipPrefixLen", this.ipPrefixLen).add("gateway", (Object)this.gateway).add("bridge", (Object)this.bridge).add("portMapping", (Object)this.portMapping).add("ports", this.ports).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkSettings.builder().fromNetworkSettings(this);
    }

    public static final class Builder {
        private String ipAddress;
        private int ipPrefixLen;
        private String gateway;
        private String bridge;
        private String portMapping;
        private Map<String, List<Map<String, String>>> ports = ImmutableMap.of();

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipPrefixLen(int ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder bridge(String bridge) {
            this.bridge = bridge;
            return this;
        }

        public Builder portMapping(String portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public Builder ports(Map<String, List<Map<String, String>>> ports) {
            this.ports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(ports, (Object)"ports")));
            return this;
        }

        public NetworkSettings build() {
            return new NetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.ports);
        }

        public Builder fromNetworkSettings(NetworkSettings in) {
            return this.ipAddress(in.getIpAddress()).ipPrefixLen(in.getIpPrefixLen()).gateway(in.getGateway()).bridge(in.getBridge()).portMapping(in.getPortMapping()).ports(in.getPorts());
        }
    }
}

