/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.handlers.NeutronErrorHandler;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@ConfiguresHttpApi
public class NeutronHttpApiModule
extends HttpApiModule<NeutronApi> {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet.class);
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    @Provides
    @Singleton
    public LoadingCache<String, Set<? extends Extension>> provideExtensionsByRegion(final Provider<NeutronApi> neutronApi) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Set<? extends Extension>>(){

            public Set<? extends Extension> load(String key) throws Exception {
                return ((NeutronApi)neutronApi.get()).getExtensionApi(key).list();
            }
        });
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(NeutronErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(NeutronErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(NeutronErrorHandler.class);
    }
}

