/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.neutron.v2_0.domain.NetworkType;

public class BulkNetwork {
    private final String name;
    private final Boolean adminStateUp;
    private final Boolean external;
    private final NetworkType networkType;
    private final String physicalNetworkName;
    private final Integer segmentationId;

    @ConstructorProperties(value={"name", "admin_state_up", "router:external", "provider:network_type", "provider:physical_network", "provider:segmentation_id"})
    protected BulkNetwork(String name, Boolean adminStateUp, Boolean external, String networkType, String physicalNetworkName, Integer segmentationId) {
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.external = external;
        this.networkType = NetworkType.fromValue(networkType);
        this.physicalNetworkName = physicalNetworkName;
        this.segmentationId = segmentationId;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getPhysicalNetworkName() {
        return this.physicalNetworkName;
    }

    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.adminStateUp, this.external, this.networkType, this.physicalNetworkName, this.segmentationId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BulkNetwork that = (BulkNetwork)BulkNetwork.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.external, (Object)that.external) && Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType)) && Objects.equal((Object)this.physicalNetworkName, (Object)that.physicalNetworkName) && Objects.equal((Object)this.segmentationId, (Object)that.segmentationId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("adminStateUp", (Object)this.adminStateUp).add("external", (Object)this.external).add("networkType", (Object)this.networkType).add("physicalNetworkName", (Object)this.physicalNetworkName).add("segmentationId", (Object)this.segmentationId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromBulkNetwork(this);
    }

    public static abstract class Builder {
        protected String name;
        protected Boolean adminStateUp;
        protected Boolean external;
        protected NetworkType networkType;
        protected String physcialNetworkName;
        protected Integer segmentationId;

        protected abstract Builder self();

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public Builder external(Boolean external) {
            this.external = external;
            return this.self();
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this.self();
        }

        public Builder physicalNetworkName(String physicalNetworkName) {
            this.physcialNetworkName = physicalNetworkName;
            return this.self();
        }

        public Builder segmentationId(Integer segmentationId) {
            this.segmentationId = segmentationId;
            return this.self();
        }

        public BulkNetwork build() {
            return new BulkNetwork(this.name, this.adminStateUp, this.external, this.networkType == null ? null : this.networkType.getValue(), this.physcialNetworkName, this.segmentationId);
        }

        public Builder fromBulkNetwork(BulkNetwork in) {
            return this.name(in.getName()).adminStateUp(in.getAdminStateUp()).external(in.getExternal()).networkType(in.getNetworkType()).physicalNetworkName(in.getPhysicalNetworkName()).segmentationId(in.getSegmentationId());
        }
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

