/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.neutron.v2_0.domain.AllocationPool;
import org.jclouds.openstack.neutron.v2_0.domain.HostRoute;

public class BulkSubnet {
    protected String name;
    protected String networkId;
    protected String gatewayIp;
    protected Integer ipVersion;
    protected String cidr;
    protected Set<AllocationPool> allocationPools;
    protected Boolean enableDhcp;
    protected Set<String> dnsNameServers;
    protected Set<HostRoute> hostRoutes;

    @ConstructorProperties(value={"name", "network_id", "gateway_ip", "ip_version", "cidr", "allocation_pools", "enable_dhcp", "dns_nameservers", "host_routes"})
    protected BulkSubnet(String name, String networkId, String gatewayIp, Integer ipVersion, String cidr, Set<AllocationPool> allocationPools, Boolean enableDhcp, Set<String> dnsNameServers, Set<HostRoute> hostRoutes) {
        this.name = name;
        this.networkId = networkId;
        this.gatewayIp = gatewayIp;
        this.ipVersion = ipVersion;
        this.cidr = cidr;
        this.allocationPools = allocationPools != null ? ImmutableSet.copyOf(allocationPools) : ImmutableSet.of();
        this.enableDhcp = enableDhcp;
        this.dnsNameServers = dnsNameServers != null ? ImmutableSet.copyOf(dnsNameServers) : ImmutableSet.of();
        this.hostRoutes = hostRoutes != null ? ImmutableSet.copyOf(hostRoutes) : ImmutableSet.of();
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getGatewayIp() {
        return this.gatewayIp;
    }

    public Integer getIpVersion() {
        return this.ipVersion;
    }

    public String getCidr() {
        return this.cidr;
    }

    public Set<AllocationPool> getAllocationPools() {
        return this.allocationPools;
    }

    public Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    public Set<String> getDnsNameServers() {
        return this.dnsNameServers;
    }

    public Set<HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.networkId, this.gatewayIp, this.ipVersion, this.cidr, this.allocationPools, this.enableDhcp, this.dnsNameServers, this.hostRoutes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BulkSubnet that = (BulkSubnet)BulkSubnet.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.gatewayIp, (Object)that.gatewayIp) && Objects.equal((Object)this.ipVersion, (Object)that.ipVersion) && Objects.equal((Object)this.cidr, (Object)that.cidr) && Objects.equal(this.allocationPools, that.allocationPools) && Objects.equal((Object)this.enableDhcp, (Object)that.enableDhcp) && Objects.equal(this.dnsNameServers, that.dnsNameServers) && Objects.equal(this.hostRoutes, that.hostRoutes);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("networkId", (Object)this.networkId).add("gatewayIp", (Object)this.gatewayIp).add("ipVersion", (Object)this.ipVersion).add("cidr", (Object)this.cidr).add("enableDhcp", (Object)this.enableDhcp).add("allocationPools", this.allocationPools).add("dnsNameServers", this.dnsNameServers).add("hostRoutes", this.hostRoutes);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromBulkSubnet(this);
    }

    public static abstract class Builder {
        protected String name;
        protected String networkId;
        protected String gatewayIp;
        protected Integer ipVersion;
        protected String cidr;
        protected Set<AllocationPool> allocationPools;
        protected Boolean enableDhcp;
        protected Set<String> dnsNameServers;
        protected Set<HostRoute> hostRoutes;

        protected abstract Builder self();

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public Builder gatewayIp(String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return this.self();
        }

        public Builder ipVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
            return this.self();
        }

        public Builder cidr(String cidr) {
            this.cidr = cidr;
            return this.self();
        }

        public Builder allocationPools(Collection<AllocationPool> allocationPools) {
            this.allocationPools = ImmutableSet.copyOf(allocationPools);
            return this.self();
        }

        public Builder enableDhcp(Boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return this.self();
        }

        public Builder dnsNameServers(Collection<String> dnsNameServers) {
            this.dnsNameServers = ImmutableSet.copyOf(dnsNameServers);
            return this.self();
        }

        public Builder hostRoutes(Collection<HostRoute> hostRoutes) {
            this.hostRoutes = ImmutableSet.copyOf(hostRoutes);
            return this.self();
        }

        public BulkSubnet build() {
            return new BulkSubnet(this.name, this.networkId, this.gatewayIp, this.ipVersion, this.cidr, this.allocationPools, this.enableDhcp, this.dnsNameServers, this.hostRoutes);
        }

        public Builder fromBulkSubnet(BulkSubnet in) {
            return this.name(in.getName()).networkId(in.getNetworkId()).gatewayIp(in.getGatewayIp()).ipVersion(in.getIpVersion()).cidr(in.getCidr()).allocationPools(in.getAllocationPools()).enableDhcp(in.getEnableDhcp()).dnsNameServers(in.getDnsNameServers()).hostRoutes(in.getHostRoutes());
        }
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

