/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;

public class IP {
    private String ipAddress;
    private String subnetId;

    @ConstructorProperties(value={"ip_address", "subnet_id"})
    protected IP(String ipAddress, String subnetId) {
        this.ipAddress = ipAddress;
        this.subnetId = subnetId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipAddress, this.subnetId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IP that = (IP)IP.class.cast(obj);
        return Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.subnetId, (Object)that.subnetId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("ipAddress", (Object)this.ipAddress).add("subnetId", (Object)this.subnetId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromIP(this);
    }

    public static abstract class Builder {
        protected String ipAddress;
        protected String subnetId;

        protected abstract Builder self();

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this.self();
        }

        public IP build() {
            return new IP(this.ipAddress, this.subnetId);
        }

        public Builder fromIP(IP in) {
            return this.ipAddress(in.getIpAddress()).subnetId(in.getSubnetId());
        }
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

