/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Reference {
    private final String id;
    private final String tenantId;

    @ConstructorProperties(value={"id", "tenant_id"})
    protected Reference(String id, String tenantId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.tenantId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Reference that = (Reference)Reference.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.tenantId, (Object)that.tenantId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("tenantId", (Object)this.tenantId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromReference(this);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String tenantId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public Reference build() {
            return new Reference(this.id, this.tenantId);
        }

        public T fromReference(Reference in) {
            return ((Builder)this.id(in.getId())).tenantId(in.getTenantId());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

