/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.neutron.v2_0.domain.Reference;

public class ReferenceWithName
extends Reference {
    private final String name;

    @ConstructorProperties(value={"id", "tenant_id", "name"})
    protected ReferenceWithName(String id, String tenantId, String name) {
        super(id, tenantId);
        this.name = Strings.nullToEmpty((String)name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.name});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceWithName that = (ReferenceWithName)ReferenceWithName.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)this.name, (Object)that.name);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("name", (Object)this.name);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromReferenceWithName(this);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Reference.Builder<T> {
        protected String name;

        @Override
        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return (T)this.self();
        }

        @Override
        public ReferenceWithName build() {
            return new ReferenceWithName(this.id, this.tenantId, this.name);
        }

        public T fromReferenceWithName(ReferenceWithName in) {
            return ((Builder)super.fromReference(in)).name(in.getName());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

