/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2_0.domain.Network;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.functions.ParseNetworkDetails;
import org.jclouds.openstack.neutron.v2_0.functions.ParseNetworks;
import org.jclouds.openstack.neutron.v2_0.options.CreateNetworkBulkOptions;
import org.jclouds.openstack.neutron.v2_0.options.CreateNetworkOptions;
import org.jclouds.openstack.neutron.v2_0.options.UpdateNetworkOptions;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Deprecated
@Path(value="/v2.0/networks")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
public interface NetworkApi {
    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworks.class)
    @Transform(value=ParseNetworks.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @QueryParams(keys={"fields", "fields", "fields"}, values={"id", "tenant_id", "name"})
    public PagedIterable<? extends ReferenceWithName> list();

    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworks.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @QueryParams(keys={"fields", "fields", "fields"}, values={"id", "tenant_id", "name"})
    public PagedIterable<? extends ReferenceWithName> list(PaginationOptions var1);

    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworkDetails.class)
    @Transform(value=ParseNetworkDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<? extends Network> listInDetail();

    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworkDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PagedIterable<? extends Network> listInDetail(PaginationOptions var1);

    @Named(value="network:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"network"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Network get(@PathParam(value="id") String var1);

    @Named(value="network:create")
    @POST
    @SelectJson(value={"network"})
    @MapBinder(value=CreateNetworkOptions.class)
    public Network create(CreateNetworkOptions ... var1);

    @Named(value="network:createBulk")
    @POST
    @SelectJson(value={"networks"})
    @MapBinder(value=CreateNetworkBulkOptions.class)
    public FluentIterable<? extends Network> createBulk(CreateNetworkBulkOptions var1);

    @Named(value="network:update")
    @PUT
    @Path(value="/{id}")
    @MapBinder(value=UpdateNetworkOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean update(@PathParam(value="id") String var1, UpdateNetworkOptions ... var2);

    @Named(value="network:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

