/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2_0.domain.Port;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.functions.ParsePortDetails;
import org.jclouds.openstack.neutron.v2_0.functions.ParsePorts;
import org.jclouds.openstack.neutron.v2_0.options.CreatePortBulkOptions;
import org.jclouds.openstack.neutron.v2_0.options.CreatePortOptions;
import org.jclouds.openstack.neutron.v2_0.options.UpdatePortOptions;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Deprecated
@Path(value="/v2.0/ports")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
public interface PortApi {
    @Named(value="port:list")
    @GET
    @ResponseParser(value=ParsePorts.class)
    @Transform(value=ParsePorts.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @QueryParams(keys={"fields", "fields", "fields"}, values={"id", "tenant_id", "name"})
    public PagedIterable<? extends ReferenceWithName> list();

    @Named(value="port:list")
    @GET
    @ResponseParser(value=ParsePorts.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @QueryParams(keys={"fields", "fields", "fields"}, values={"id", "tenant_id", "name"})
    public PagedIterable<? extends ReferenceWithName> list(PaginationOptions var1);

    @Named(value="port:list")
    @GET
    @ResponseParser(value=ParsePortDetails.class)
    @Transform(value=ParsePortDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<? extends Port> listInDetail();

    @Named(value="port:list")
    @GET
    @ResponseParser(value=ParsePortDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PagedIterable<? extends Port> listInDetail(PaginationOptions var1);

    @Named(value="port:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"port"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Port get(@PathParam(value="id") String var1);

    @Named(value="port:create")
    @POST
    @SelectJson(value={"port"})
    @MapBinder(value=CreatePortOptions.class)
    public Port create(@PayloadParam(value="network_id") String var1, CreatePortOptions ... var2);

    @Named(value="port:createBulk")
    @POST
    @SelectJson(value={"ports"})
    @MapBinder(value=CreatePortBulkOptions.class)
    public FluentIterable<? extends Port> createBulk(CreatePortBulkOptions var1);

    @Named(value="port:update")
    @PUT
    @Path(value="/{id}")
    @MapBinder(value=UpdatePortOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean update(@PathParam(value="id") String var1, UpdatePortOptions ... var2);

    @Named(value="port:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

