/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.neutron.v2_0.NeutronApi;
import org.jclouds.openstack.neutron.v2_0.domain.Router;
import org.jclouds.openstack.neutron.v2_0.extensions.RouterApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseRouterDetails
extends ParseJson<Routers> {
    @Inject
    public ParseRouterDetails(Json json) {
        super(json, TypeLiteral.get(Routers.class));
    }

    static class Routers
    extends PaginatedCollection<Router> {
        @ConstructorProperties(value={"routers", "routers_links"})
        protected Routers(Iterable<Router> routers, Iterable<Link> routersLinks) {
            super(routers, routersLinks);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Router, ToPagedIterable> {
        private final NeutronApi api;

        @Inject
        protected ToPagedIterable(NeutronApi api) {
            this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Router>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.isPresent() ? arg0.get().toString() : null;
            final RouterApi routerApi = (RouterApi)this.api.getRouterExtensionForZone(zone).get();
            return new Function<Object, IterableWithMarker<Router>>(){

                public IterableWithMarker<Router> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(routerApi.listInDetail(PaginationOptions.Builder.marker((String)input.toString())));
                }

                public String toString() {
                    return "listRoutersInDetail()";
                }
            };
        }
    }
}

