/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.neutron.v2_0.NeutronApi;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.features.SubnetApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseSubnets
extends ParseJson<Subnets> {
    @Inject
    public ParseSubnets(Json json) {
        super(json, TypeLiteral.get(Subnets.class));
    }

    static class Subnets
    extends PaginatedCollection<ReferenceWithName> {
        @ConstructorProperties(value={"subnets", "subnets_links"})
        protected Subnets(Iterable<ReferenceWithName> subnets, Iterable<Link> subnetsLinks) {
            super(subnets, subnetsLinks);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<ReferenceWithName, ToPagedIterable> {
        private final NeutronApi api;

        @Inject
        protected ToPagedIterable(NeutronApi api) {
            this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<ReferenceWithName>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.isPresent() ? arg0.get().toString() : null;
            final SubnetApi subnetApi = this.api.getSubnetApiForZone(zone);
            return new Function<Object, IterableWithMarker<ReferenceWithName>>(){

                public IterableWithMarker<ReferenceWithName> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(subnetApi.list(paginationOptions));
                }

                public String toString() {
                    return "listSubnets()";
                }
            };
        }
    }
}

