/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.ExternalGatewayInfo;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateRouterOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    protected String name;
    protected Boolean adminStateUp;
    protected ExternalGatewayInfo externalGatewayInfo;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreateRouterOptions(this);
    }

    protected CreateRouterOptions() {
        this.name = null;
        this.adminStateUp = null;
        this.externalGatewayInfo = null;
    }

    public CreateRouterOptions(String name, Boolean adminStateUp, ExternalGatewayInfo externalGatewayInfo) {
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.externalGatewayInfo = externalGatewayInfo;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public ExternalGatewayInfo getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        CreateRouterRequest createRouterRequest = new CreateRouterRequest();
        if (this.name != null) {
            createRouterRequest.name = this.name;
        }
        if (this.adminStateUp != null) {
            createRouterRequest.admin_state_up = this.adminStateUp;
        }
        if (this.externalGatewayInfo != null) {
            createRouterRequest.external_gateway_info = new CreateRouterRequest.ExternalGatewayInfo(this.externalGatewayInfo.getNetworkId());
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"router", (Object)createRouterRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Boolean adminStateUp;
        protected ExternalGatewayInfo externalGatewayInfo;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public T externalGatewayInfo(ExternalGatewayInfo externalGatewayInfo) {
            this.externalGatewayInfo = externalGatewayInfo;
            return this.self();
        }

        public CreateRouterOptions build() {
            return new CreateRouterOptions(this.name, this.adminStateUp, this.externalGatewayInfo);
        }

        public T fromCreateRouterOptions(CreateRouterOptions options) {
            return ((Builder)((Builder)this.name(options.getName())).adminStateUp(options.getAdminStateUp())).externalGatewayInfo(options.getExternalGatewayInfo());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    protected static class CreateRouterRequest {
        protected String name;
        protected Boolean admin_state_up;
        protected ExternalGatewayInfo external_gateway_info;

        protected CreateRouterRequest() {
        }

        protected static final class ExternalGatewayInfo {
            protected String network_id;

            protected ExternalGatewayInfo(String network_id) {
                this.network_id = network_id;
            }
        }
    }
}

