/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.ExternalGatewayInfo;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateRouterOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    protected String name;
    protected Boolean adminStateUp;
    protected ExternalGatewayInfo externalGatewayInfo;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUpdateRouterOptions(this);
    }

    protected UpdateRouterOptions() {
        this.name = null;
        this.adminStateUp = null;
        this.externalGatewayInfo = null;
    }

    public UpdateRouterOptions(String name, Boolean adminStateUp, ExternalGatewayInfo externalGatewayInfo) {
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.externalGatewayInfo = externalGatewayInfo;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public ExternalGatewayInfo getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        UpdateRouterRequest updateRouterRequest = new UpdateRouterRequest();
        if (this.name != null) {
            updateRouterRequest.name = this.name;
        }
        if (this.adminStateUp != null) {
            updateRouterRequest.admin_state_up = this.adminStateUp;
        }
        if (this.externalGatewayInfo != null) {
            updateRouterRequest.external_gateway_info = new UpdateRouterRequest.ExternalGatewayInfo(this.externalGatewayInfo.getNetworkId());
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"router", (Object)updateRouterRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Boolean adminStateUp;
        protected ExternalGatewayInfo externalGatewayInfo;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public T externalGatewayInfo(ExternalGatewayInfo externalGatewayInfo) {
            this.externalGatewayInfo = externalGatewayInfo;
            return this.self();
        }

        public UpdateRouterOptions build() {
            return new UpdateRouterOptions(this.name, this.adminStateUp, this.externalGatewayInfo);
        }

        public T fromUpdateRouterOptions(UpdateRouterOptions options) {
            return ((Builder)((Builder)this.name(options.getName())).adminStateUp(options.getAdminStateUp())).externalGatewayInfo(options.getExternalGatewayInfo());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    protected static class UpdateRouterRequest {
        protected String name;
        protected Boolean admin_state_up;
        protected ExternalGatewayInfo external_gateway_info;

        protected UpdateRouterRequest() {
        }

        protected static final class ExternalGatewayInfo {
            protected String network_id;

            protected ExternalGatewayInfo(String network_id) {
                this.network_id = network_id;
            }
        }
    }
}

