/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.HostRoute;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateSubnetOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final String gatewayIp;
    private final Boolean enableDhcp;
    private final Set<String> dnsNameServers;
    private final Set<HostRoute> hostRoutes;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUpdateSubnetOptions(this);
    }

    protected UpdateSubnetOptions() {
        this.name = null;
        this.gatewayIp = null;
        this.enableDhcp = null;
        this.dnsNameServers = Sets.newHashSet();
        this.hostRoutes = Sets.newHashSet();
    }

    public UpdateSubnetOptions(String name, String gatewayIp, Boolean enableDhcp, Set<String> dnsNameServers, Set<HostRoute> hostRoutes) {
        this.name = name;
        this.gatewayIp = gatewayIp;
        this.enableDhcp = enableDhcp;
        this.dnsNameServers = dnsNameServers != null ? ImmutableSet.copyOf(dnsNameServers) : Sets.newHashSet();
        this.hostRoutes = hostRoutes != null ? ImmutableSet.copyOf(hostRoutes) : Sets.newHashSet();
    }

    public String getName() {
        return this.name;
    }

    public String getGatewayIp() {
        return this.gatewayIp;
    }

    public Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    public Set<String> getDnsNameServers() {
        return this.dnsNameServers;
    }

    public Set<HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        UpdateSubnetRequest updateSubnetRequest = new UpdateSubnetRequest();
        if (this.name != null) {
            updateSubnetRequest.name = this.name;
        }
        if (this.gatewayIp != null) {
            updateSubnetRequest.gateway_ip = this.gatewayIp;
        }
        if (this.enableDhcp != null) {
            updateSubnetRequest.enable_dhcp = this.enableDhcp;
        }
        if (!this.dnsNameServers.isEmpty()) {
            updateSubnetRequest.dns_nameservers = this.dnsNameServers;
        }
        if (!this.hostRoutes.isEmpty()) {
            updateSubnetRequest.host_routes = Sets.newHashSet();
            for (HostRoute hostRoute : this.hostRoutes) {
                UpdateSubnetRequest.HostRoute requestHostRoute = new UpdateSubnetRequest.HostRoute();
                requestHostRoute.destination = hostRoute.getDestinationCidr();
                requestHostRoute.nexthop = hostRoute.getNextHop();
                updateSubnetRequest.host_routes.add(requestHostRoute);
            }
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"subnet", (Object)updateSubnetRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String gatewayIp;
        protected Boolean enableDhcp;
        protected Set<String> dnsNameServers;
        protected Set<HostRoute> hostRoutes;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T gatewayIp(String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return this.self();
        }

        public T enableDhcp(Boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return this.self();
        }

        public T dnsNameServers(Collection<String> dnsNameServers) {
            this.dnsNameServers = ImmutableSet.copyOf(dnsNameServers);
            return this.self();
        }

        public T hostRoutes(Collection<HostRoute> hostRoutes) {
            this.hostRoutes = ImmutableSet.copyOf(hostRoutes);
            return this.self();
        }

        public UpdateSubnetOptions build() {
            return new UpdateSubnetOptions(this.name, this.gatewayIp, this.enableDhcp, this.dnsNameServers, this.hostRoutes);
        }

        public T fromUpdateSubnetOptions(UpdateSubnetOptions in) {
            return ((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).gatewayIp(in.getGatewayIp())).enableDhcp(in.getEnableDhcp())).dnsNameServers(in.getDnsNameServers())).hostRoutes(in.getHostRoutes());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    private static class UpdateSubnetRequest {
        protected String name;
        protected String gateway_ip;
        protected Boolean enable_dhcp;
        protected Set<String> dns_nameservers;
        protected Set<HostRoute> host_routes;

        private UpdateSubnetRequest() {
        }

        private static class HostRoute {
            protected String destination;
            protected String nexthop;

            private HostRoute() {
            }
        }
    }
}

