/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.FileTransferMode;
import org.ggf.drmaa.InvalidAttributeFormatException;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.PartialTimestamp;
import org.ggf.drmaa.PartialTimestampFormat;
import org.ggf.drmaa.UnsupportedAttributeException;

public class SimpleJobTemplate
implements JobTemplate,
Serializable {
    private String toString = null;
    private Set<String> allPropertyNames = null;
    private boolean modified = true;
    protected String remoteCommand = null;
    protected List<String> args = null;
    protected int jobSubmissionState = 1;
    protected Map<String, String> jobEnvironment = null;
    protected String workingDirectory = null;
    protected String jobCategory = null;
    protected String nativeSpecification = null;
    protected Set<String> email = null;
    protected boolean blockEmail = false;
    protected PartialTimestamp startTime = null;
    protected String jobName = null;
    protected String inputPath = null;
    protected String outputPath = null;
    protected String errorPath = null;
    protected boolean joinFiles = false;

    @Override
    public void setRemoteCommand(String remoteCommand) throws DrmaaException {
        this.remoteCommand = remoteCommand;
        this.modified = true;
    }

    @Override
    public String getRemoteCommand() throws DrmaaException {
        return this.remoteCommand;
    }

    @Override
    public void setArgs(List<String> args) throws DrmaaException {
        this.args = args != null ? new ArrayList<String>(args) : null;
        this.modified = true;
    }

    @Override
    public List<String> getArgs() throws DrmaaException {
        List<String> returnValue = null;
        if (this.args != null) {
            returnValue = Collections.unmodifiableList(this.args);
        }
        return returnValue;
    }

    @Override
    public void setJobSubmissionState(int state) throws DrmaaException {
        if (state != 1 && state != 0) {
            throw new IllegalArgumentException("Invalid state");
        }
        this.jobSubmissionState = state;
        this.modified = true;
    }

    @Override
    public int getJobSubmissionState() throws DrmaaException {
        return this.jobSubmissionState;
    }

    @Override
    public void setJobEnvironment(Map<String, String> env) throws DrmaaException {
        this.jobEnvironment = env != null ? new HashMap<String, String>(env) : null;
        this.modified = true;
    }

    @Override
    public Map<String, String> getJobEnvironment() throws DrmaaException {
        Map<String, String> returnValue = null;
        if (this.jobEnvironment != null) {
            returnValue = Collections.unmodifiableMap(this.jobEnvironment);
        }
        return returnValue;
    }

    @Override
    public void setWorkingDirectory(String wd) throws DrmaaException {
        if (wd.indexOf("$drmaa_hd_ph$") > 0) {
            throw new InvalidAttributeFormatException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (wd.indexOf("$drmaa_wd_ph$") >= 0) {
            throw new InvalidAttributeFormatException("$drmaa_wd_ph$ may not be used in the workingDirectory path.");
        }
        this.workingDirectory = wd;
        this.modified = true;
    }

    @Override
    public String getWorkingDirectory() throws DrmaaException {
        return this.workingDirectory;
    }

    @Override
    public void setJobCategory(String category) throws DrmaaException {
        this.jobCategory = category;
        this.modified = true;
    }

    @Override
    public String getJobCategory() throws DrmaaException {
        return this.jobCategory;
    }

    @Override
    public void setNativeSpecification(String spec) throws DrmaaException {
        this.nativeSpecification = spec;
        this.modified = true;
    }

    @Override
    public String getNativeSpecification() throws DrmaaException {
        return this.nativeSpecification;
    }

    @Override
    public void setEmail(Set<String> email) throws DrmaaException {
        this.email = email != null ? new HashSet<String>(email) : null;
        this.modified = true;
    }

    @Override
    public Set<String> getEmail() throws DrmaaException {
        Set<String> returnValue = null;
        if (this.email != null) {
            returnValue = Collections.unmodifiableSet(this.email);
        }
        return returnValue;
    }

    @Override
    public void setBlockEmail(boolean blockEmail) throws DrmaaException {
        this.blockEmail = blockEmail;
        this.modified = true;
    }

    @Override
    public boolean getBlockEmail() throws DrmaaException {
        return this.blockEmail;
    }

    @Override
    public void setStartTime(PartialTimestamp startTime) throws DrmaaException {
        if (startTime != null) {
            if (startTime.getTimeInMillis() < System.currentTimeMillis()) {
                throw new IllegalArgumentException("Start time is in the past.");
            }
            this.startTime = startTime;
        } else {
            startTime = null;
        }
        this.modified = true;
    }

    @Override
    public PartialTimestamp getStartTime() throws DrmaaException {
        if (this.startTime != null) {
            return (PartialTimestamp)this.startTime.clone();
        }
        return null;
    }

    @Override
    public void setJobName(String name) throws DrmaaException {
        this.jobName = name;
        this.modified = true;
    }

    @Override
    public String getJobName() throws DrmaaException {
        return this.jobName;
    }

    @Override
    public void setInputPath(String inputPath) throws DrmaaException {
        this.checkPath(inputPath);
        this.inputPath = inputPath;
        this.modified = true;
    }

    @Override
    public String getInputPath() throws DrmaaException {
        return this.inputPath;
    }

    @Override
    public void setOutputPath(String outputPath) throws DrmaaException {
        this.checkPath(outputPath);
        this.outputPath = outputPath;
        this.modified = true;
    }

    @Override
    public String getOutputPath() throws DrmaaException {
        return this.outputPath;
    }

    @Override
    public void setErrorPath(String errorPath) throws DrmaaException {
        this.checkPath(errorPath);
        this.errorPath = errorPath;
        this.modified = true;
    }

    @Override
    public String getErrorPath() throws DrmaaException {
        return this.errorPath;
    }

    @Override
    public void setJoinFiles(boolean join) throws DrmaaException {
        this.joinFiles = join;
        this.modified = true;
    }

    @Override
    public boolean getJoinFiles() throws DrmaaException {
        return this.joinFiles;
    }

    @Override
    public void setTransferFiles(FileTransferMode mode) throws DrmaaException {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    @Override
    public FileTransferMode getTransferFiles() throws DrmaaException {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    @Override
    public void setDeadlineTime(PartialTimestamp deadline) throws DrmaaException {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    @Override
    public PartialTimestamp getDeadlineTime() throws DrmaaException {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    @Override
    public void setHardWallclockTimeLimit(long hardWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    @Override
    public long getHardWallclockTimeLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    @Override
    public void setSoftWallclockTimeLimit(long softWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    @Override
    public long getSoftWallclockTimeLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    @Override
    public void setHardRunDurationLimit(long hardRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    @Override
    public long getHardRunDurationLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    @Override
    public void setSoftRunDurationLimit(long softRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    @Override
    public long getSoftRunDurationLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    @Override
    public Set<String> getAttributeNames() throws DrmaaException {
        if (this.allPropertyNames == null) {
            this.allPropertyNames = new HashSet<String>();
            SimpleJobTemplate.addRequiredNames(this.allPropertyNames);
            this.allPropertyNames.addAll(this.getOptionalAttributeNames());
        }
        return this.allPropertyNames;
    }

    protected Set<String> getOptionalAttributeNames() {
        return Collections.emptySet();
    }

    private static final void addRequiredNames(Set<String> names) {
        names.add("args");
        names.add("blockEmail");
        names.add("email");
        names.add("errorPath");
        names.add("inputPath");
        names.add("jobCategory");
        names.add("jobEnvironment");
        names.add("jobName");
        names.add("jobSubmissionState");
        names.add("joinFiles");
        names.add("nativeSpecification");
        names.add("outputPath");
        names.add("remoteCommand");
        names.add("startTime");
        names.add("workingDirectory");
    }

    private void checkPath(String path) throws IllegalArgumentException {
        if (path == null) {
            return;
        }
        if (path.indexOf("$drmaa_hd_ph$") > 0) {
            throw new IllegalArgumentException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (path.indexOf("$drmaa_wd_ph$") > 0) {
            throw new IllegalArgumentException("$drmaa_wd_ph$ may only appear at the beginning of the path.");
        }
    }

    protected void modified() {
        this.modified = true;
    }

    public String toString() {
        if (this.modified) {
            boolean error = false;
            boolean firstProperty = true;
            StringBuffer out = new StringBuffer();
            List<String> args = null;
            try {
                args = this.getArgs();
            }
            catch (DrmaaException drmaaException) {
                out.append("{args = <ERROR>}");
                firstProperty = false;
                error = true;
            }
            if (args != null && args.size() > 0) {
                Iterator<String> i = args.iterator();
                boolean firstArg = true;
                out.append("{args = ");
                while (i.hasNext()) {
                    if (firstArg) {
                        firstArg = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("\"");
                    out.append(i.next());
                    out.append("\"");
                }
                out.append("}");
                firstProperty = false;
            }
            if (!firstProperty) {
                out.append(" ");
            }
            out.append("{blockEmail = ");
            try {
                out.append(Boolean.toString(this.getBlockEmail()));
            }
            catch (DrmaaException drmaaException) {
                out.append("<ERROR>");
                error = true;
            }
            out.append("}");
            try {
                if (this.getDeadlineTime() != null) {
                    PartialTimestampFormat ptf = new PartialTimestampFormat();
                    out.append(" {deadlineTime = ");
                    out.append(ptf.format(this.getDeadlineTime()));
                    out.append("}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {deadlineTime = <ERROR>}");
                error = true;
            }
            Set<String> email = null;
            try {
                email = this.getEmail();
            }
            catch (DrmaaException drmaaException) {
                out.append(" {email = <ERROR>}");
                error = true;
            }
            if (email != null && email.size() > 0) {
                Iterator<String> i = email.iterator();
                boolean firstEmail = true;
                out.append(" {email = ");
                while (i.hasNext()) {
                    if (firstEmail) {
                        firstEmail = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("\"");
                    out.append(i.next());
                    out.append("\"");
                }
                out.append("}");
            }
            try {
                if (this.getErrorPath() != null) {
                    out.append(" {errorPath = ");
                    out.append(this.getErrorPath());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {errorPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getHardRunDurationLimit() != 0L) {
                    out.append(" {hardRunDurationLimit = ");
                    out.append(this.getHardRunDurationLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {hardRunDurationLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getHardWallclockTimeLimit() != 0L) {
                    out.append(" {hardWallclockTimeLimit = ");
                    out.append(this.getHardWallclockTimeLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {hardWallclockTimeLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getInputPath() != null) {
                    out.append(" {inputPath = ");
                    out.append(this.getInputPath());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {inputPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getJobCategory() != null) {
                    out.append(" {jobCategory = ");
                    out.append(this.getJobCategory());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {jobCategory = <ERROR>}");
                error = true;
            }
            Map<String, String> env = null;
            try {
                env = this.getJobEnvironment();
            }
            catch (DrmaaException drmaaException) {
                out.append(" {jobEnvironment = <ERROR>}");
                error = true;
            }
            if (env != null && env.size() > 0) {
                Iterator<String> i = env.keySet().iterator();
                boolean firstEnv = true;
                out.append(" {jobEnvironment = ");
                while (i.hasNext()) {
                    String entry = i.next();
                    if (firstEnv) {
                        firstEnv = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("[\"");
                    out.append(entry);
                    out.append("\" = \"");
                    out.append(env.get(entry));
                    out.append("\"]");
                }
                out.append("}");
            }
            try {
                if (this.getJobName() != null) {
                    out.append(" {jobName = ");
                    out.append(this.getJobName());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {jobName = <ERROR>}");
                error = true;
            }
            out.append(" {jobSubmissionState = ");
            try {
                if (this.getJobSubmissionState() == 0) {
                    out.append("HOLD_STATE}");
                } else {
                    out.append("ACTIVE_STATE}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {jobSubmissionState = <ERROR>}");
                error = true;
            }
            out.append(" {joinFiles = ");
            try {
                out.append(Boolean.toString(this.getJoinFiles()));
            }
            catch (DrmaaException drmaaException) {
                out.append(" {joinFiles = <ERROR>}");
                error = true;
            }
            out.append("}");
            try {
                if (this.getNativeSpecification() != null) {
                    out.append(" {nativeSpecification = \"");
                    out.append(this.getNativeSpecification());
                    out.append("\"}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {nativeSpecification = <ERROR>}");
                error = true;
            }
            try {
                if (this.getOutputPath() != null) {
                    out.append(" {outputPath = ");
                    out.append(this.getOutputPath());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {outputPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getRemoteCommand() != null) {
                    out.append(" {remoteCommand = ");
                    out.append(this.getRemoteCommand());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {remoteCommand = <ERROR>}");
                error = true;
            }
            try {
                if (this.getSoftRunDurationLimit() != 0L) {
                    out.append(" {softRunDurationLimit = ");
                    out.append(this.getSoftRunDurationLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {softRunDurationLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getSoftWallclockTimeLimit() != 0L) {
                    out.append(" {softWallclockTimeLimit = ");
                    out.append(this.getSoftWallclockTimeLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {softWallclockTimeLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getStartTime() != null) {
                    PartialTimestampFormat ptf = new PartialTimestampFormat();
                    out.append(" {startTime = \"");
                    out.append(ptf.format(this.getStartTime()));
                    out.append("\"}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {startTime = <ERROR>}");
                error = true;
            }
            try {
                if (this.getTransferFiles() != null) {
                    out.append(" {transferFiles = \"");
                    out.append(this.getTransferFiles().toString());
                    out.append("\"}");
                }
            }
            catch (UnsupportedAttributeException unsupportedAttributeException) {
            }
            catch (DrmaaException drmaaException) {
                out.append(" {transferFiles = <ERROR>}");
                error = true;
            }
            try {
                if (this.getWorkingDirectory() != null) {
                    out.append(" {workingDirectory = ");
                    out.append(this.getWorkingDirectory());
                    out.append("}");
                }
            }
            catch (DrmaaException drmaaException) {
                out.append(" {workingDirectory = <ERROR>}");
                error = true;
            }
            this.toString = out.toString();
            this.modified = error;
        }
        return this.toString;
    }
}

