/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.Font;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class PieStyler
extends Styler {
    private PieSeries.PieSeriesRenderStyle chartPieSeriesRenderStyle;
    private boolean isCircular;
    private double startAngleInDegrees;
    private double annotationDistance;
    private AnnotationType annotationType;
    private boolean drawAllAnnotations;
    private double donutThickness;
    private boolean isSumVisible;
    private Font sumFont;
    private String sumFormat;
    private ClockwiseDirectionType clockwiseDirectionType = ClockwiseDirectionType.COUNTER_CLOCKWISE;
    private float borderWidth = 0.0f;

    public PieStyler() {
        this.setAllStyles();
    }

    @Override
    void setAllStyles() {
        super.setAllStyles();
        this.chartPieSeriesRenderStyle = PieSeries.PieSeriesRenderStyle.Pie;
        this.isCircular = this.theme.isCircular();
        this.startAngleInDegrees = this.theme.getStartAngleInDegrees();
        this.annotationDistance = this.theme.getAnnotationDistance();
        this.annotationType = this.theme.getAnnotationType();
        this.drawAllAnnotations = this.theme.isDrawAllAnnotations();
        this.donutThickness = this.theme.getDonutThickness();
        this.hasAnnotations = true;
        this.isSumVisible = this.theme.isSumVisible();
        this.sumFont = this.theme.getSumFont();
    }

    public PieSeries.PieSeriesRenderStyle getDefaultSeriesRenderStyle() {
        return this.chartPieSeriesRenderStyle;
    }

    public PieStyler setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle chartPieSeriesRenderStyle) {
        this.chartPieSeriesRenderStyle = chartPieSeriesRenderStyle;
        return this;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public PieStyler setCircular(boolean isCircular) {
        this.isCircular = isCircular;
        return this;
    }

    public double getStartAngleInDegrees() {
        return this.startAngleInDegrees;
    }

    public PieStyler setStartAngleInDegrees(double startAngleInDegrees) {
        this.startAngleInDegrees = startAngleInDegrees;
        return this;
    }

    public double getAnnotationDistance() {
        return this.annotationDistance;
    }

    public void setAnnotationDistance(double annotationDistance) {
        this.annotationDistance = annotationDistance;
    }

    public AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public PieStyler setAnnotationType(AnnotationType annotationType) {
        this.annotationType = annotationType;
        return this;
    }

    public boolean isDrawAllAnnotations() {
        return this.drawAllAnnotations;
    }

    public PieStyler setDrawAllAnnotations(boolean drawAllAnnotations) {
        this.drawAllAnnotations = drawAllAnnotations;
        return this;
    }

    public double getDonutThickness() {
        return this.donutThickness;
    }

    public void setDonutThickness(double donutThickness) {
        this.donutThickness = donutThickness;
    }

    public boolean isSumVisible() {
        return this.isSumVisible;
    }

    public PieStyler setSumFormat(String sumFormat) {
        this.sumFormat = sumFormat;
        return this;
    }

    public String getSumFormat() {
        return this.sumFormat;
    }

    public PieStyler setSumVisible(boolean isSumVisible) {
        this.isSumVisible = isSumVisible;
        return this;
    }

    public Font getSumFont() {
        return this.sumFont;
    }

    public PieStyler setSumFont(Font sumFont) {
        this.sumFont = sumFont;
        return this;
    }

    public PieStyler setSumFontSize(float sumFontSize) {
        this.sumFont = this.sumFont.deriveFont(sumFontSize);
        return this;
    }

    public PieStyler setTheme(Theme theme) {
        this.theme = theme;
        this.setAllStyles();
        return this;
    }

    public ClockwiseDirectionType getClockwiseDirectionType() {
        return this.clockwiseDirectionType;
    }

    public PieStyler setClockwiseDirectionType(ClockwiseDirectionType clockwiseDirectionType) {
        this.clockwiseDirectionType = clockwiseDirectionType;
        return this;
    }

    public PieStyler setBorderWidth(double borderWidth) {
        this.borderWidth = (float)borderWidth;
        return this;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public static enum ClockwiseDirectionType {
        CLOCKWISE,
        COUNTER_CLOCKWISE;

    }

    public static enum AnnotationType {
        Value,
        Percentage,
        Label,
        LabelAndPercentage,
        LabelAndValue;

    }
}

