/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests.util;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.tests.util.FixedCredentialsProvider;
import org.eclipse.userstorage.tests.util.Fixture;
import org.eclipse.userstorage.tests.util.USSServer;
import org.eclipse.userstorage.util.NotFoundException;
import org.eclipse.userstorage.util.Settings;

public class ServerFixture
extends Fixture {
    public static final File SERVER_FOLDER = new File(TEST_FOLDER, "server");
    private final String applicationToken;
    private USSServer server;
    private USSServer.User user;
    private IStorageService.Dynamic service;

    public ServerFixture(String applicationToken) throws Exception {
        this.applicationToken = applicationToken;
        this.configureServerLogging();
        if (this.manageBundleLifecycle()) {
            Activator.start();
        }
        if (REMOTE) {
            this.service = IStorageService.Registry.INSTANCE.addService("Eclipse.org (Staging)", StringUtil.newURI((String)"https://api-staging.eclipse.org/"));
            System.out.println();
            System.out.println("### Reset Begin ###");
            this.createFactory(applicationToken).create(applicationToken).deleteAllBlobs();
            System.out.println("### Reset Done ###");
            System.out.println();
        } else {
            IOUtil.deleteFiles((File)SERVER_FOLDER);
            this.server = new USSServer(8080, SERVER_FOLDER);
            this.user = this.server.addUser(FixedCredentialsProvider.DEFAULT_CREDENTIALS);
            this.server.getApplicationTokens().add(applicationToken);
            int port = this.server.start();
            this.service = IStorageService.Registry.INSTANCE.addService("Local", StringUtil.newURI((String)("http://localhost:" + port)));
        }
    }

    public final String getApplicationToken() {
        return this.applicationToken;
    }

    public final boolean hasLocalServer() {
        return this.server != null;
    }

    public final USSServer getServer() {
        return this.server;
    }

    public final USSServer.User getUser() {
        return this.user;
    }

    public final IStorageService.Dynamic getService() {
        return this.service;
    }

    public final StorageFactory createFactory(String applicationToken) throws Exception {
        Settings.MemorySettings settings = new Settings.MemorySettings();
        settings.setValue(applicationToken, this.service.getServiceURI().toString());
        return new StorageFactory((ISettings)settings);
    }

    public final BlobInfo readServer(IBlob blob) throws Exception {
        IBlob tmpBlob;
        BlobInfo result;
        block9: {
            result = new BlobInfo();
            String applicationToken = blob.getStorage().getApplicationToken();
            String key = blob.getKey();
            if (this.hasLocalServer()) {
                File etagFile;
                File blobFile;
                block8: {
                    try {
                        blobFile = this.server.getUserFile(this.user, applicationToken, key, ".blob");
                        etagFile = this.server.getUserFile(this.user, applicationToken, key, ".etag");
                        if (blobFile.isFile() && etagFile.isFile()) break block8;
                        return null;
                    }
                    catch (RuntimeException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw ex;
                    }
                }
                result.contents = IOUtil.readUTF((File)blobFile);
                result.eTag = IOUtil.readUTF((File)etagFile);
            }
            try {
                StorageFactory factory = this.createFactory(applicationToken);
                IStorage tmpStorage = factory.create(applicationToken);
                tmpBlob = tmpStorage.getBlob(key);
                result.contents = tmpBlob.getContentsUTF();
                if (result.contents != null) break block9;
                return null;
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        }
        result.eTag = tmpBlob.getETag();
        return result;
    }

    public final String writeServer(IBlob blob, String value) throws Exception {
        String applicationToken = blob.getStorage().getApplicationToken();
        String key = blob.getKey();
        if (this.hasLocalServer()) {
            String eTag = UUID.randomUUID().toString();
            IOUtil.writeUTF((File)this.server.getUserFile(this.user, applicationToken, key, ".etag"), (String)eTag);
            IOUtil.writeUTF((File)this.server.getUserFile(this.user, applicationToken, key, ".blob"), (String)value);
            return eTag;
        }
        StorageFactory factory = this.createFactory(applicationToken);
        IStorage tmpStorage = factory.create(applicationToken);
        IBlob tmpBlob = tmpStorage.getBlob(key);
        tmpBlob.setETag(blob.getETag());
        tmpBlob.setContentsUTF(value);
        return tmpBlob.getETag();
    }

    @Override
    public void dispose() throws Exception {
        this.user = null;
        if (this.service != null) {
            this.service.remove();
            this.service = null;
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        if (this.manageBundleLifecycle()) {
            Activator.stop();
        }
        super.dispose();
    }

    protected void configureServerLogging() {
        Log.setLog((Logger)new USSServer.NOOPLogger());
    }

    protected boolean manageBundleLifecycle() {
        return true;
    }

    public static final class BlobInfo {
        public String eTag;
        public String contents;
    }
}

