/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.form;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthHelper {
    public static LoginResult performAuthentication(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        String username = req.getParameter("UserName".toLowerCase());
        UserInfo userInfo = FormAuthHelper.getUserForCredentials(username, req.getParameter("Password".toLowerCase()));
        if (userInfo != null) {
            if (userInfo.getProperties().containsKey("Blocked")) {
                return LoginResult.BLOCKED;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Login success: " + username);
            }
            req.getSession().setAttribute("user", (Object)username);
            try {
                userInfo.setProperty("LastLoginTimestamp", new Long(System.currentTimeMillis()).toString());
                OrionConfiguration.getMetaStore().updateUser(userInfo);
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
            return LoginResult.OK;
        }
        if (username != null) {
            logger.info("Login failed: " + username);
        }
        return LoginResult.FAIL;
    }

    private static UserInfo getUserForCredentials(String username, String password) {
        try {
            UserInfo userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", username, false, false);
            if (userInfo != null && userInfo.getProperty("Password") != null) {
                String userPassword = userInfo.getProperty("Password");
                if (userPassword.equals(password)) {
                    return userInfo;
                }
                return null;
            }
        }
        catch (CoreException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured when validating user credentials", (Throwable)e));
        }
        return null;
    }

    public static boolean canAddUsers() {
        boolean allowAnonymousAccountCreation = PreferenceHelper.getString((String)"orion.auth.user.creation", null) == null;
        return allowAnonymousAccountCreation;
    }

    public static boolean forceEmail() {
        return PreferenceHelper.getString((String)"orion.auth.user.creation.force.email", (String)"false").equalsIgnoreCase("true");
    }

    public static String registrationURI() {
        return PreferenceHelper.getString((String)"orion.auth.registration.uri", null);
    }

    public static JSONObject getUserJson(String username, String contextPath) throws JSONException {
        JSONObject json = new JSONObject();
        try {
            UserInfo userInfo = OrionConfiguration.getMetaStore().readUser(username);
            if (userInfo == null) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.authentication", 1, "An error occured when reading the user from the meta store: username is " + username, null));
                return new JSONObject();
            }
            json.put("FullName", (Object)userInfo.getFullName());
            json.put("UserName", (Object)userInfo.getUserName());
            json.put("Location", (Object)(String.valueOf(contextPath) + "/users" + '/' + userInfo.getUserName()));
            String email = userInfo.getProperty("Email");
            json.put("Email", (Object)email);
            boolean emailConfirmed = email != null && email.length() > 0 ? userInfo.getProperty("EmailConfirmationId") == null : false;
            json.put("EmailConfirmed", emailConfirmed);
            json.put("HasPassword", userInfo.getProperty("Password") != null);
            if (userInfo.getProperty("OAuth") != null) {
                json.put("OAuth", (Object)userInfo.getProperty("OAuth"));
            }
            if (userInfo.getProperty("OpenId") != null) {
                json.put("OpenId", (Object)userInfo.getProperty("OpenId"));
            }
            json.put("LastLoginTimestamp", (Object)userInfo.getProperty("LastLoginTimestamp"));
            json.put("DiskUsageTimestamp", (Object)userInfo.getProperty("DiskUsageTimestamp"));
            json.put("DiskUsage", (Object)userInfo.getProperty("DiskUsage"));
        }
        catch (IllegalArgumentException e) {
            LogHelper.log((Throwable)e);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return json;
    }

    public static enum LoginResult {
        OK,
        FAIL,
        BLOCKED;

    }
}

