/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.logs.jobs;

import ch.qos.logback.classic.Logger;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.logs.ILogService;
import org.eclipse.orion.server.logs.objects.LoggerResource;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListLoggersJob
extends TaskJob {
    private final ILogService logService;
    private final URI baseLocation;

    public ListLoggersJob(String userRunningTask, ILogService logService, URI baseLocation) {
        super(userRunningTask, false);
        this.logService = logService;
        this.baseLocation = baseLocation;
    }

    protected IStatus performJob() {
        try {
            List<Logger> loggers = this.logService.getLoggers();
            JSONObject loggersJSON = new JSONObject();
            loggersJSON.put("Children", (Object)new JSONArray());
            for (Logger logger : loggers) {
                LoggerResource loggerResource = new LoggerResource();
                loggerResource.setBaseLocation(this.baseLocation);
                loggerResource.setName(logger.getName());
                loggerResource.setLevel(logger.getLevel());
                loggerResource.setEffectiveLevel(logger.getEffectiveLevel());
                loggersJSON.append("Children", (Object)loggerResource.toJSON());
            }
            return new ServerStatus(Status.OK_STATUS, 200, loggersJSON);
        }
        catch (Exception e) {
            return new ServerStatus(4, 500, "An error occured when listing loggers", (Throwable)e);
        }
    }
}

