/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class SHA1RevFilter
extends RevFilter {
    String sha1;

    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException();
        }
        return new SHA1RevFilter(pattern);
    }

    SHA1RevFilter(String sha1) {
        this.sha1 = sha1;
    }

    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return cmit.getName().contains(this.sha1);
    }

    public RevFilter clone() {
        return this;
    }
}

