/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.metastore;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreMigration;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUserPropertyCache;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.internal.server.core.metastore.SimpleUserPasswordUtil;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.eclipse.orion.server.core.metastore.MetadataInfo;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMetaStore
implements IMetaStore {
    public static final String DEFAULT_WORKSPACE_NAME = "Orion Content";
    public static final String DESCRIPTION = "This JSON file is at the root of the Orion metadata store responsible for persisting user, workspace and project files and metadata.";
    public static final String ORION_DESCRIPTION = "OrionDescription";
    public static final String ORION_VERSION = "OrionVersion";
    public static final int ORION_VERSION_MISSING = -1;
    public static final String ROOT = "metastore";
    public static final String USER = "user";
    public static final int VERSION = 8;
    public static final String WORKSPACE = "workspace";
    private final Map<String, ReadWriteLock> lockMap = Collections.synchronizedMap(new HashMap());
    private File rootLocation = null;
    private SimpleMetaStoreUserPropertyCache userPropertyCache = new SimpleMetaStoreUserPropertyCache();
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");

    public SimpleMetaStore(File rootLocation) throws CoreException {
        this.rootLocation = rootLocation;
        this.initializeMetaStore(rootLocation);
    }

    @Override
    public void createProject(ProjectInfo projectInfo) throws CoreException {
        WorkspaceInfo workspaceInfo;
        if (projectInfo.getWorkspaceId() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: workspace id is null.", null));
        }
        if (projectInfo.getFullName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: project name is null.", null));
        }
        try {
            workspaceInfo = this.readWorkspace(projectInfo.getWorkspaceId());
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ", workspace does not exist.", null));
        }
        if (workspaceInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ", workspace does not exist.", null));
        }
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(projectInfo.getWorkspaceId());
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(projectInfo.getWorkspaceId());
            String projectId = SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectInfo.getFullName());
            projectInfo.setUniqueId(projectId);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(ORION_VERSION, 8);
                jsonObject.put("UniqueId", (Object)projectInfo.getUniqueId());
                jsonObject.put("WorkspaceId", (Object)projectInfo.getWorkspaceId());
                jsonObject.put("FullName", (Object)projectInfo.getFullName());
                if (projectInfo.getContentLocation() != null) {
                    URI contentLocation = projectInfo.getContentLocation();
                    String encodedContentLocation = SimpleMetaStoreUtil.encodeProjectContentLocation(contentLocation.toString());
                    jsonObject.put("ContentLocation", (Object)encodedContentLocation);
                }
                JSONObject properties = this.updateProperties(jsonObject, projectInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, (Throwable)e));
            }
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
            if (!(SimpleMetaStoreUtil.isMetaFolder(workspaceMetaFolder, projectId) || projectInfo.getContentLocation() != null && !projectInfo.getProjectStore().equals(this.getDefaultContentLocation(projectInfo)) || SimpleMetaStoreUtil.createMetaFolder(workspaceMetaFolder, projectId))) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, null));
            }
            if (!SimpleMetaStoreUtil.createMetaFile(userMetaFolder, projectId, jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createProject: could not create project: " + projectInfo.getFullName() + " for user " + userId, null));
            }
            ArrayList<String> newProjectNames = new ArrayList<String>();
            newProjectNames.addAll(workspaceInfo.getProjectNames());
            newProjectNames.add(projectInfo.getFullName());
            workspaceInfo.setProjectNames(newProjectNames);
            this.updateWorkspace(workspaceInfo);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void createUser(UserInfo userInfo) throws CoreException {
        if (userInfo.getUserName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user, did not provide a userName", null));
        }
        String userId = userInfo.getUserName();
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            userInfo.setProperty("AccountCreationTimestamp", new Long(System.currentTimeMillis()).toString());
            userInfo.setUniqueId(userId);
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            if (SimpleMetaStoreUtil.isMetaFolder(this.getRootLocation(), userId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userId + ", user already exists", null));
            }
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(ORION_VERSION, 8);
                jsonObject.put("UniqueId", (Object)userId);
                jsonObject.put("UserName", (Object)userId);
                jsonObject.put("FullName", (Object)userInfo.getFullName());
                jsonObject.put("WorkspaceIds", (Object)new JSONArray());
                JSONObject properties = this.updateProperties(jsonObject, userInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userId, (Throwable)e));
            }
            if (!SimpleMetaStoreUtil.createMetaUserFolder(this.getRootLocation(), userId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userId, null));
            }
            if (SimpleMetaStoreUtil.isMetaFile(userMetaFolder, USER) ? !SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, USER, jsonObject) : !SimpleMetaStoreUtil.createMetaFile(userMetaFolder, USER, jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createUser: could not create user: " + userId, null));
            }
            if (this.userPropertyCache.isRegistered("UserName")) {
                this.userPropertyCache.add("UserName", userId, userId);
            }
            this.logger.debug("Created new user " + userId + ".");
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void createWorkspace(WorkspaceInfo workspaceInfo) throws CoreException {
        UserInfo userInfo;
        if (workspaceInfo.getUserId() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: user id is null.", null));
        }
        if (workspaceInfo.getFullName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: workspace name is null.", null));
        }
        if (!DEFAULT_WORKSPACE_NAME.equals(workspaceInfo.getFullName())) {
            this.logger.info("SimpleMetaStore.createWorkspace: workspace name conflict: name will be \"Orion Content\": user " + workspaceInfo.getUserId() + " provided " + workspaceInfo.getFullName() + " instead.");
            workspaceInfo.setFullName(DEFAULT_WORKSPACE_NAME);
        }
        try {
            userInfo = this.readUser(workspaceInfo.getUserId());
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not find user with id: " + workspaceInfo.getUserId() + ", user does not exist.", null));
        }
        if (userInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not find user with id: " + workspaceInfo.getUserId() + ", user does not exist.", null));
        }
        if (!userInfo.getWorkspaceIds().isEmpty()) {
            String existingWorkspaceIds = userInfo.getWorkspaceIds().get(0);
            this.logger.info("SimpleMetaStore.createWorkspace: workspace conflict: cannot create a second workspace for user id: " + userInfo.getUniqueId() + ", existing workspace is being used: " + existingWorkspaceIds);
            workspaceInfo.setUniqueId(existingWorkspaceIds);
            return;
        }
        ReadWriteLock lock = this.getLockForUser(userInfo.getUniqueId());
        lock.writeLock().lock();
        try {
            String workspaceId = SimpleMetaStoreUtil.encodeWorkspaceId(workspaceInfo.getUserId(), workspaceInfo.getFullName());
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userInfo.getUniqueId());
            workspaceInfo.setUniqueId(workspaceId);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(ORION_VERSION, 8);
                jsonObject.put("UniqueId", (Object)workspaceInfo.getUniqueId());
                jsonObject.put("UserId", (Object)workspaceInfo.getUserId());
                jsonObject.put("FullName", (Object)workspaceInfo.getFullName());
                jsonObject.put("ProjectNames", (Object)new JSONArray());
                JSONObject properties = this.updateProperties(jsonObject, workspaceInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), (Throwable)e));
            }
            if (!SimpleMetaStoreUtil.createMetaFolder(userMetaFolder, encodedWorkspaceName)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), null));
            }
            if (SimpleMetaStoreUtil.isMetaFile(userMetaFolder, workspaceId)) {
                File workspaceMetaFile = SimpleMetaStoreUtil.retrieveMetaFile(userMetaFolder, workspaceId);
                this.logger.info("SimpleMetaStore.createWorkspace: workspace conflict: while creating a workspace for user id: " + userInfo.getUniqueId() + ", found existing workspace json, will not overwrite: " + workspaceMetaFile.toString());
            } else if (!SimpleMetaStoreUtil.createMetaFile(userMetaFolder, workspaceId, jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.createWorkspace: could not create workspace: " + encodedWorkspaceName + " for user " + userInfo.getUserName(), null));
            }
            ArrayList<String> newWorkspaceIds = new ArrayList<String>();
            newWorkspaceIds.addAll(userInfo.getWorkspaceIds());
            newWorkspaceIds.add(workspaceId);
            userInfo.setWorkspaceIds(newWorkspaceIds);
            this.updateUser(userInfo);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteProject(String workspaceId, String projectName) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            WorkspaceInfo workspaceInfo;
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
            try {
                workspaceInfo = this.readWorkspace(workspaceId);
            }
            catch (CoreException coreException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteProject: could not find project with name:" + projectName + ", workspace does not exist.", null));
            }
            ArrayList<String> newProjectIds = new ArrayList<String>();
            newProjectIds.addAll(workspaceInfo.getProjectNames());
            newProjectIds.remove(projectName);
            workspaceInfo.setProjectNames(newProjectIds);
            this.updateWorkspace(workspaceInfo);
            String projectId = SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectName);
            if (!SimpleMetaStoreUtil.deleteMetaFile(userMetaFolder, projectId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteProject: could not delete project: " + projectName + " for user " + userId, null));
            }
            if (SimpleMetaStoreUtil.isMetaFolder(workspaceMetaFolder, projectId) && !SimpleMetaStoreUtil.deleteMetaFolder(workspaceMetaFolder, projectId, true)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteProject: could not delete project: " + projectName + " for user " + userId, null));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteUser(String userId) throws CoreException {
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            UserInfo userInfo;
            try {
                userInfo = this.readUser(userId);
            }
            catch (CoreException coreException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user with id: " + userId + ", user does not exist.", null));
            }
            for (String workspaceId : userInfo.getWorkspaceIds()) {
                this.deleteWorkspace(userId, workspaceId);
            }
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            if (!SimpleMetaStoreUtil.deleteMetaFile(userMetaFolder, USER)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user: " + userId, null));
            }
            if (!SimpleMetaStoreUtil.deleteMetaUserFolder(userMetaFolder, userId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteUser: could not delete user: " + userId, null));
            }
            this.userPropertyCache.deleteUser(userId);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteWorkspace(String userId, String workspaceId) throws CoreException {
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            UserInfo userInfo;
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            WorkspaceInfo workspaceInfo = this.readWorkspace(workspaceId);
            for (String projectName : workspaceInfo.getProjectNames()) {
                this.deleteProject(workspaceId, projectName);
            }
            try {
                userInfo = this.readUser(userId);
            }
            catch (CoreException coreException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not find user with id:" + userId + ", user does not exist.", null));
            }
            ArrayList<String> newWorkspaceIds = new ArrayList<String>();
            newWorkspaceIds.addAll(userInfo.getWorkspaceIds());
            newWorkspaceIds.remove(workspaceId);
            userInfo.setWorkspaceIds(newWorkspaceIds);
            this.updateUser(userInfo);
            if (!SimpleMetaStoreUtil.deleteMetaFile(userMetaFolder, workspaceId)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not delete workspace: " + encodedWorkspaceName, null));
            }
            if (!SimpleMetaStoreUtil.deleteMetaFolder(userMetaFolder, encodedWorkspaceName, true)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.deleteWorkspace: could not delete workspace: " + encodedWorkspaceName, null));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public IFileStore getDefaultContentLocation(ProjectInfo projectInfo) throws CoreException {
        if (projectInfo.getWorkspaceId() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.getDefaultContentLocation: workspace id is null.", null));
        }
        if (projectInfo.getFullName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.getDefaultContentLocation: project name is null.", null));
        }
        IFileStore workspaceFolder = this.getWorkspaceContentLocation(projectInfo.getWorkspaceId());
        String projectId = SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectInfo.getFullName());
        IFileStore projectFolder = workspaceFolder.getChild(projectId);
        return projectFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadWriteLock getLockForUser(String userId) {
        Map<String, ReadWriteLock> map = this.lockMap;
        synchronized (map) {
            if (!this.lockMap.containsKey(userId)) {
                ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
                this.lockMap.put(userId, lock);
                return lock;
            }
            return this.lockMap.get(userId);
        }
    }

    protected File getRootLocation() {
        return this.rootLocation;
    }

    @Override
    public IFileStore getUserHome(String userId) {
        IFileStore root = OrionConfiguration.getRootLocation();
        if (userId != null) {
            String userPrefix = userId.substring(0, Math.min(2, userId.length()));
            return root.getChild(userPrefix).getChild(userId);
        }
        return root;
    }

    private JSONObject getUserProperties(UserInfo userInfo) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Map<String, String> properties = userInfo.getProperties();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if ("UserRights".equals(key)) {
                JSONArray userRights = new JSONArray(value);
                jsonObject.put("UserRights", (Object)userRights);
                continue;
            }
            if ("SiteConfigurations".equals(key)) {
                JSONObject siteConfigurations = new JSONObject(value);
                jsonObject.put("SiteConfigurations", (Object)siteConfigurations);
                continue;
            }
            if ("Password".equals(key)) {
                String password = SimpleUserPasswordUtil.encryptPassword(value);
                jsonObject.put(key, (Object)password);
                continue;
            }
            jsonObject.put(key, (Object)value);
        }
        return jsonObject;
    }

    @Override
    public IFileStore getWorkspaceContentLocation(String workspaceId) throws CoreException {
        if (workspaceId == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.getWorkspaceContentLocation: workspace id is null.", null));
        }
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
        File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
        IFileStore userHome = this.getUserHome(userId);
        IFileStore workspaceFolder = userHome.getChild(workspaceMetaFolder.getName());
        return workspaceFolder;
    }

    protected void initializeMetaStore(File rootLocation) throws CoreException {
        if (!SimpleMetaStoreUtil.isMetaFile(rootLocation, ROOT)) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(ORION_VERSION, 8);
                jsonObject.put(ORION_DESCRIPTION, (Object)DESCRIPTION);
            }
            catch (JSONException e) {
                this.logger.error("SimpleMetaStore.initializeMetaStore: JSON error.", (Throwable)e);
                throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not create new metastore.json");
            }
            if (!SimpleMetaStoreUtil.createMetaFile(rootLocation, ROOT, jsonObject)) {
                throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not create MetaStore");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Created new simple metadata store (version 8).");
            }
        } else {
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(rootLocation, ROOT);
            try {
                int version = jsonObject.getInt(ORION_VERSION);
                if (version < 8) {
                    jsonObject.put(ORION_VERSION, 8);
                    jsonObject.put(ORION_DESCRIPTION, (Object)DESCRIPTION);
                    if (!SimpleMetaStoreUtil.updateMetaFile(rootLocation, ROOT, jsonObject)) {
                        throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not update MetaStore");
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Updated simple metadata store to a new version (version 8).");
                    }
                } else if (version > 8) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.initializeMetaStore: cannot run an old server (version 8) on metadata that is at a newer version (version " + version + ")", null));
                }
            }
            catch (JSONException e) {
                this.logger.error("SimpleMetaStore.initializeMetaStore: JSON error.", (Throwable)e);
                throw new RuntimeException("SimpleMetaStore.initializeMetaStore: could not read or update metastore.json");
            }
        }
        this.logger.info("Loaded simple metadata store (version 8).");
    }

    @Override
    public List<String> readAllUsers() throws CoreException {
        long start = System.currentTimeMillis();
        List<String> userIds = SimpleMetaStoreUtil.listMetaUserFolders(this.getRootLocation());
        this.logger.info("Finished reading " + userIds.size() + " users, duration: " + (System.currentTimeMillis() - start) + "ms");
        return userIds;
    }

    @Override
    public ProjectInfo readProject(String workspaceId, String projectName) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        if (userId == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SimpleMetaStore.readProject: requested with a bad userId in the workspaceId " + workspaceId);
            }
            return null;
        }
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.readLock().lock();
        try {
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
            if (encodedWorkspaceName == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SimpleMetaStore.readProject: requested with a bad workspaceId " + workspaceId);
                }
                return null;
            }
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
            if (workspaceMetaFolder == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SimpleMetaStore.readProject: workspaceMetaFolder does not exist for workspace " + workspaceId);
                }
                return null;
            }
            String projectId = SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectName);
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, projectId);
            ProjectInfo projectInfo = new ProjectInfo();
            if (jsonObject == null) {
                if (SimpleMetaStoreUtil.isMetaFolder(workspaceMetaFolder, projectId) && !SimpleMetaStoreUtil.isMetaFile(userMetaFolder, projectId)) {
                    File projectMetaFolder = SimpleMetaStoreUtil.readMetaFolder(workspaceMetaFolder, projectId);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("SimpleMetaStore.readProject: the project folder " + projectMetaFolder.toString() + " exists but the project json file does not, so creating it in " + workspaceId);
                    }
                    URI projectLocation = projectMetaFolder.toURI();
                    projectInfo.setFullName(projectName);
                    projectInfo.setWorkspaceId(workspaceId);
                    projectInfo.setContentLocation(projectLocation);
                    lock.readLock().unlock();
                    this.createProject(projectInfo);
                    lock.readLock().lock();
                    jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, projectId);
                } else {
                    return null;
                }
            }
            try {
                projectInfo.setUniqueId(jsonObject.getString("UniqueId"));
                projectInfo.setWorkspaceId(jsonObject.getString("WorkspaceId"));
                projectInfo.setFullName(jsonObject.getString("FullName"));
                if (jsonObject.has("ContentLocation")) {
                    String decodedContentLocation = SimpleMetaStoreUtil.decodeProjectContentLocation(jsonObject.getString("ContentLocation"));
                    projectInfo.setContentLocation(new URI(decodedContentLocation));
                }
                this.setProperties(projectInfo, jsonObject.getJSONObject("Properties"));
                projectInfo.flush();
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readProject: could not read project " + projectName + " for userId " + userId, (Throwable)e));
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readProject: could not read project " + projectName + " for userId " + userId, (Throwable)e));
            }
            ProjectInfo projectInfo2 = projectInfo;
            return projectInfo2;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public UserInfo readUser(String userId) throws CoreException {
        block19: {
            if (userId == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readUser: user is null", null));
            }
            ReadWriteLock lock = this.getLockForUser(userId);
            lock.readLock().lock();
            try {
                File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
                if (!SimpleMetaStoreUtil.isMetaFile(userMetaFolder, USER)) break block19;
                JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, USER);
                if (jsonObject == null) {
                    this.logger.info("SimpleMetaStore.readUser: could not read user " + userId);
                    return null;
                }
                UserInfo userInfo = new UserInfo();
                try {
                    SimpleMetaStoreMigration migration = new SimpleMetaStoreMigration();
                    if (migration.isMigrationRequired(jsonObject)) {
                        this.logger.info("Migration: Migration required for user " + userId + " to the latest (version " + 8 + ")");
                        lock.readLock().unlock();
                        lock.writeLock().lock();
                        try {
                            jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, USER);
                            if (migration.isMigrationRequired(jsonObject)) {
                                migration.doMigration(this.getRootLocation(), userMetaFolder);
                            } else {
                                this.logger.info("Migration: Migration no longer required for user " + userId + ", completed in other thread");
                            }
                        }
                        finally {
                            lock.writeLock().unlock();
                        }
                        lock.readLock().lock();
                        jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, USER);
                    }
                    userInfo.setUniqueId(jsonObject.getString("UniqueId"));
                    userInfo.setUserName(jsonObject.getString("UserName"));
                    if (jsonObject.isNull("FullName")) {
                        userInfo.setFullName("Unnamed User");
                    } else {
                        userInfo.setFullName(jsonObject.getString("FullName"));
                    }
                    ArrayList<String> userWorkspaceIds = new ArrayList<String>();
                    JSONArray workspaceIds = jsonObject.getJSONArray("WorkspaceIds");
                    if (workspaceIds.length() > 0) {
                        int i = 0;
                        while (i < workspaceIds.length()) {
                            userWorkspaceIds.add(workspaceIds.getString(i));
                            ++i;
                        }
                    }
                    userInfo.setWorkspaceIds(userWorkspaceIds);
                    if (userInfo.getWorkspaceIds().size() > 1) {
                        this.logger.warn("SimpleMetaStore.readUser: user id " + userInfo.getUniqueId() + " has a multiple workspace conflict: workspace: " + userInfo.getWorkspaceIds().get(0) + " and workspace: " + userInfo.getWorkspaceIds().get(1));
                    }
                    this.setProperties(userInfo, jsonObject.getJSONObject("Properties"));
                    userInfo.flush();
                }
                catch (JSONException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readUser: could not read user " + userId, (Throwable)e));
                }
                UserInfo userInfo2 = userInfo;
                return userInfo2;
            }
            finally {
                lock.readLock().unlock();
            }
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setUniqueId(userId);
        userInfo.setUserName(userId);
        userInfo.setFullName("Unnamed User");
        this.createUser(userInfo);
        return userInfo;
    }

    @Override
    public UserInfo readUserByProperty(String key, String value, boolean regExp, boolean ignoreCase) throws CoreException {
        String userId = null;
        if ("UserName".equals(key)) {
            if (SimpleMetaStoreUtil.isMetaUserFolder(this.getRootLocation(), value)) {
                userId = value;
            }
        } else {
            userId = this.userPropertyCache.readUserByProperty(key, value, regExp, ignoreCase);
        }
        if (userId != null) {
            return this.readUser(userId);
        }
        return null;
    }

    @Override
    public WorkspaceInfo readWorkspace(String workspaceId) throws CoreException {
        if (workspaceId == null) {
            return null;
        }
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceId);
        String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceId);
        if (userId == null || encodedWorkspaceName == null) {
            return null;
        }
        if (!SimpleMetaStoreUtil.isMetaUserFolder(this.getRootLocation(), userId)) {
            return null;
        }
        File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
        if (!SimpleMetaStoreUtil.isMetaFolder(userMetaFolder, encodedWorkspaceName)) {
            return null;
        }
        JSONObject jsonObject = null;
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.readLock().lock();
        try {
            jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, workspaceId);
            if (jsonObject == null) {
                return null;
            }
            WorkspaceInfo workspaceInfo = new WorkspaceInfo();
            try {
                workspaceInfo.setUniqueId(jsonObject.getString("UniqueId"));
                workspaceInfo.setUserId(jsonObject.getString("UserId"));
                workspaceInfo.setFullName(jsonObject.getString("FullName"));
                ArrayList<String> workspaceProjectNames = new ArrayList<String>();
                JSONArray projectNames = jsonObject.getJSONArray("ProjectNames");
                if (projectNames.length() > 0) {
                    int i = 0;
                    while (i < projectNames.length()) {
                        workspaceProjectNames.add(projectNames.getString(i));
                        ++i;
                    }
                }
                workspaceInfo.setProjectNames(workspaceProjectNames);
                this.setProperties(workspaceInfo, jsonObject.getJSONObject("Properties"));
                workspaceInfo.flush();
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.readWorkspace: could not read workspace " + encodedWorkspaceName + " for user id " + userId, (Throwable)e));
            }
            WorkspaceInfo workspaceInfo2 = workspaceInfo;
            return workspaceInfo2;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    @Override
    public void registerUserProperties(List<String> keys) throws CoreException {
        this.userPropertyCache.register(keys);
        if (!keys.contains("UserName") || keys.size() != 1) {
            long start = System.currentTimeMillis();
            int usersCount = this.initializeAllRegisteredPropertiesFromDisk();
            this.logger.info("Finished processing " + usersCount + " users for registerUserProperties, duration: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private int initializeAllRegisteredPropertiesFromDisk() {
        List<String> allUsers = SimpleMetaStoreUtil.listMetaUserFolders(this.rootLocation);
        for (String user : allUsers) {
            File userMetaFile = SimpleMetaStoreUtil.readMetaUserFolder(this.rootLocation, user);
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFile, USER);
            JSONObject properties = null;
            try {
                properties = jsonObject.getJSONObject("Properties");
            }
            catch (JSONException e) {
                this.logger.error("SimpleMetaStore.initializeAllRegisteredPropertiesFromDisk: failed reading metafile for user " + user, (Throwable)e);
            }
            UserInfo info = new UserInfo();
            info.setUniqueId(user);
            try {
                this.setProperties(info, properties);
            }
            catch (JSONException e) {
                this.logger.error("SimpleMetaStore.initializeAllRegisteredPropertiesFromDisk: failed reading properties for user " + user, (Throwable)e);
            }
        }
        return allUsers.size();
    }

    private void setProperties(MetadataInfo metadataInfo, JSONObject jsonObject) throws JSONException {
        String[] properties = JSONObject.getNames((JSONObject)jsonObject);
        HashMap<String, String> cachedProperties = new HashMap<String, String>();
        if (properties != null) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = jsonObject.get(key).toString();
                if (key.equals("Password")) {
                    String encryptedPassword = value;
                    String password = SimpleUserPasswordUtil.decryptPassword(encryptedPassword);
                    metadataInfo.setProperty(key, password);
                } else {
                    metadataInfo.setProperty(key, value);
                }
                if (metadataInfo instanceof UserInfo && this.userPropertyCache.isRegistered(key)) {
                    cachedProperties.put(key, value);
                }
                ++n2;
            }
        }
        if (!cachedProperties.isEmpty()) {
            this.userPropertyCache.setProperties(metadataInfo.getUniqueId(), cachedProperties);
        }
    }

    @Override
    public void updateProject(ProjectInfo projectInfo) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(projectInfo.getWorkspaceId());
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(projectInfo.getWorkspaceId());
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            File workspaceMetaFolder = SimpleMetaStoreUtil.readMetaFolder(userMetaFolder, encodedWorkspaceName);
            if (!SimpleMetaStoreUtil.isMetaFile(userMetaFolder, projectInfo.getUniqueId())) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
            }
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, projectInfo.getUniqueId());
            if (!projectInfo.getUniqueId().equals(SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectInfo.getFullName()))) {
                WorkspaceInfo workspaceInfo;
                IFileStore projectStore = projectInfo.getProjectStore();
                IFileStore defaultProjectStore = this.getDefaultContentLocation(this.readProject(projectInfo.getWorkspaceId(), projectInfo.getUniqueId()));
                String newProjectId = SimpleMetaStoreUtil.encodeProjectIdFromProjectName(projectInfo.getFullName());
                if (!SimpleMetaStoreUtil.moveMetaFile(userMetaFolder, projectInfo.getUniqueId(), newProjectId)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not move project: " + projectInfo.getUniqueId() + " to " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
                }
                if (projectStore.equals(defaultProjectStore) && !SimpleMetaStoreUtil.moveMetaFolder(workspaceMetaFolder, projectInfo.getUniqueId(), newProjectId)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not move project: " + projectInfo.getUniqueId() + " to " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
                }
                if (projectInfo.getContentLocation().getScheme().equals("file")) {
                    File oldContentLocation = new File(projectInfo.getContentLocation());
                    if (workspaceMetaFolder.toString().equals(oldContentLocation.getParent())) {
                        projectInfo.setContentLocation(new File(workspaceMetaFolder, newProjectId).toURI());
                    }
                }
                try {
                    workspaceInfo = this.readWorkspace(projectInfo.getWorkspaceId());
                }
                catch (CoreException coreException) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not find workspace with id:" + projectInfo.getWorkspaceId() + ".", null));
                }
                ArrayList<String> newProjectNames = new ArrayList<String>();
                newProjectNames.addAll(workspaceInfo.getProjectNames());
                String oldProjectName = SimpleMetaStoreUtil.decodeProjectNameFromProjectId(projectInfo.getUniqueId());
                newProjectNames.remove(oldProjectName);
                newProjectNames.add(projectInfo.getFullName());
                workspaceInfo.setProjectNames(newProjectNames);
                this.updateWorkspace(workspaceInfo);
                projectInfo.setUniqueId(newProjectId);
            } else if (projectInfo.getProperty("newUserId") != null) {
                String newUserId = projectInfo.getProperty("newUserId");
                String newWorkspaceId = projectInfo.getProperty("newWorkspaceId");
                projectInfo.setWorkspaceId(newWorkspaceId);
                if (projectInfo.getContentLocation().getScheme().equals("file")) {
                    try {
                        File oldContentLocation = new File(projectInfo.getContentLocation());
                        if (workspaceMetaFolder.getCanonicalPath().equals(oldContentLocation.getParent())) {
                            String newEncodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(newWorkspaceId);
                            File newUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), newUserId);
                            File newWorkspaceMetaFolder = new File(newUserMetaFolder, newEncodedWorkspaceName);
                            projectInfo.setContentLocation(new File(newWorkspaceMetaFolder, projectInfo.getUniqueId()).toURI());
                        }
                    }
                    catch (IOException iOException) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
                    }
                }
                projectInfo.setProperty("newUserId", null);
                projectInfo.setProperty("newWorkspaceId", null);
            }
            try {
                jsonObject.put(ORION_VERSION, 8);
                jsonObject.put("UniqueId", (Object)projectInfo.getUniqueId());
                jsonObject.put("WorkspaceId", (Object)projectInfo.getWorkspaceId());
                jsonObject.put("FullName", (Object)projectInfo.getFullName());
                if (projectInfo.getContentLocation() != null) {
                    URI contentLocation = projectInfo.getContentLocation();
                    String encodedContentLocation = SimpleMetaStoreUtil.encodeProjectContentLocation(contentLocation.toString());
                    jsonObject.put("ContentLocation", (Object)encodedContentLocation);
                }
                JSONObject properties = this.updateProperties(jsonObject, projectInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException jSONException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
            }
            if (!SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, projectInfo.getUniqueId(), jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProject: could not update project: " + projectInfo.getFullName() + " for workspace " + encodedWorkspaceName, null));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private JSONObject updateProperties(JSONObject jsonObject, MetadataInfo metadataInfo) throws CoreException {
        JSONObject properties = new JSONObject();
        try {
            if (jsonObject.has("Properties")) {
                properties = jsonObject.getJSONObject("Properties");
            }
            for (String key : metadataInfo.getOperations().keySet()) {
                String value;
                MetadataInfo.OperationType operation = metadataInfo.getOperations().get(key);
                if (MetadataInfo.OperationType.DELETE.equals((Object)operation)) {
                    if (!properties.has(key)) continue;
                    value = properties.getString(key);
                    properties.remove(key);
                    if (!(metadataInfo instanceof UserInfo) || !this.userPropertyCache.isRegistered(key)) continue;
                    this.userPropertyCache.delete(key, value, metadataInfo.getUniqueId());
                    continue;
                }
                value = metadataInfo.getProperties().get(key);
                if ("UserRights".equals(key)) {
                    JSONArray userRights = new JSONArray(value);
                    properties.put("UserRights", (Object)userRights);
                    continue;
                }
                if ("SiteConfigurations".equals(key)) {
                    JSONObject siteConfigurations = new JSONObject(value);
                    properties.put("SiteConfigurations", (Object)siteConfigurations);
                    continue;
                }
                if ("Password".equals(key)) {
                    String encryptedPassword = SimpleUserPasswordUtil.encryptPassword(value);
                    properties.put("Password", (Object)encryptedPassword);
                    continue;
                }
                properties.put(key, (Object)value);
                if (!(metadataInfo instanceof UserInfo) || !this.userPropertyCache.isRegistered(key)) continue;
                this.userPropertyCache.add(key, value, metadataInfo.getUniqueId());
            }
            metadataInfo.flush();
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateProperties: could not update", (Throwable)e));
        }
        return properties;
    }

    @Override
    public void updateUser(UserInfo userInfo) throws CoreException {
        if (userInfo.getUserName() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name is null.", null));
        }
        if (!userInfo.getUniqueId().equals(userInfo.getUserName())) {
            String oldUserId = userInfo.getUniqueId();
            String newUserId = userInfo.getUserName();
            ReadWriteLock oldUserLock = this.getLockForUser(oldUserId);
            oldUserLock.writeLock().lock();
            ReadWriteLock newUserLock = this.getLockForUser(newUserId);
            newUserLock.writeLock().lock();
            try {
                List<String> oldWorkspaceIds = userInfo.getWorkspaceIds();
                ArrayList<String> newWorkspaceIds = new ArrayList<String>();
                for (String oldWorkspaceId : oldWorkspaceIds) {
                    WorkspaceInfo workspaceInfo = this.readWorkspace(oldWorkspaceId);
                    workspaceInfo.setUserId(newUserId);
                    this.updateWorkspace(workspaceInfo);
                    String newWorkspaceId = workspaceInfo.getUniqueId();
                    newWorkspaceIds.add(newWorkspaceId);
                    List<String> projectNames = workspaceInfo.getProjectNames();
                    for (String projectName : projectNames) {
                        ProjectInfo projectInfo = this.readProject(oldWorkspaceId, projectName);
                        projectInfo.setProperty("newUserId", newUserId);
                        projectInfo.setProperty("newWorkspaceId", newWorkspaceId);
                        this.updateProject(projectInfo);
                    }
                }
                try {
                    JSONObject properties = this.getUserProperties(userInfo);
                    if (properties.has("UserRights")) {
                        JSONArray userRights = properties.getJSONArray("UserRights");
                        int i = 0;
                        while (i < userRights.length()) {
                            JSONObject userRight = userRights.getJSONObject(i);
                            String uri = userRight.getString("Uri");
                            if (uri.contains(oldUserId)) {
                                uri = uri.replace(oldUserId, newUserId);
                                userRight.put("Uri", (Object)uri);
                            }
                            ++i;
                        }
                        properties.put("UserRights", (Object)userRights);
                    }
                    this.setProperties(userInfo, properties);
                }
                catch (JSONException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUserName() + " already exists, cannot rename from " + userInfo.getUniqueId(), (Throwable)e));
                }
                userInfo.setWorkspaceIds(newWorkspaceIds);
                if (SimpleMetaStoreUtil.isMetaUserFolder(this.getRootLocation(), newUserId)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUserName() + " already exists, cannot rename from " + userInfo.getUniqueId(), null));
                }
                if (!SimpleMetaStoreUtil.isMetaUserFolder(this.getRootLocation(), oldUserId)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: user name " + userInfo.getUniqueId() + " does not exist, cannot rename to " + userInfo.getUserName(), null));
                }
                File oldUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), oldUserId);
                File newUserMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), newUserId);
                SimpleMetaStoreUtil.moveUserMetaFolder(oldUserMetaFolder, newUserMetaFolder);
                userInfo.setUniqueId(newUserId);
                if (this.userPropertyCache.isRegistered("UserName")) {
                    this.userPropertyCache.delete("UserName", oldUserId, oldUserId);
                    this.userPropertyCache.add("UserName", newUserId, newUserId);
                }
                this.logger.debug("Moved MetaStore for user " + oldUserId + " to user " + newUserId + ".");
            }
            finally {
                oldUserLock.writeLock().unlock();
                newUserLock.writeLock().unlock();
            }
        }
        String userId = userInfo.getUserName();
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            File userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId);
            JSONObject jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder, USER);
            if (jsonObject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not find user " + userId, null));
            }
            try {
                jsonObject.put("UniqueId", (Object)userInfo.getUniqueId());
                jsonObject.put("UserName", (Object)userInfo.getUserName());
                jsonObject.put("FullName", (Object)userInfo.getFullName());
                JSONArray workspaceIds = new JSONArray(userInfo.getWorkspaceIds());
                jsonObject.put("WorkspaceIds", (Object)workspaceIds);
                JSONObject properties = this.updateProperties(jsonObject, userInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not update user: " + userId, (Throwable)e));
            }
            if (!SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, USER, jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateUser: could not update user: " + userId, null));
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public void updateWorkspace(WorkspaceInfo workspaceInfo) throws CoreException {
        String userId = SimpleMetaStoreUtil.decodeUserIdFromWorkspaceId(workspaceInfo.getUniqueId());
        ReadWriteLock lock = this.getLockForUser(userId);
        lock.writeLock().lock();
        try {
            File userMetaFolder;
            JSONObject jsonObject;
            String encodedWorkspaceName = SimpleMetaStoreUtil.decodeWorkspaceNameFromWorkspaceId(workspaceInfo.getUniqueId());
            boolean renameUser = false;
            String newWorkspaceId = null;
            if (!workspaceInfo.getUserId().equals(userId)) {
                renameUser = true;
                newWorkspaceId = SimpleMetaStoreUtil.encodeWorkspaceId(workspaceInfo.getUserId(), encodedWorkspaceName);
            }
            if ((jsonObject = SimpleMetaStoreUtil.readMetaFile(userMetaFolder = SimpleMetaStoreUtil.readMetaUserFolder(this.getRootLocation(), userId), workspaceInfo.getUniqueId())) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateWorkspace: could not find workspace " + workspaceInfo.getUniqueId(), null));
            }
            try {
                jsonObject.put(ORION_VERSION, 8);
                if (renameUser) {
                    jsonObject.put("UniqueId", (Object)newWorkspaceId);
                } else {
                    jsonObject.put("UniqueId", (Object)workspaceInfo.getUniqueId());
                }
                jsonObject.put("UserId", (Object)workspaceInfo.getUserId());
                jsonObject.put("FullName", (Object)workspaceInfo.getFullName());
                JSONArray projectNames = new JSONArray(workspaceInfo.getProjectNames());
                jsonObject.put("ProjectNames", (Object)projectNames);
                JSONObject properties = this.updateProperties(jsonObject, workspaceInfo);
                jsonObject.put("Properties", (Object)properties);
            }
            catch (JSONException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateWorkspace: could not update workspace: " + encodedWorkspaceName + " for user " + userId, (Throwable)e));
            }
            if (!SimpleMetaStoreUtil.updateMetaFile(userMetaFolder, workspaceInfo.getUniqueId(), jsonObject)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.core", 1, "SimpleMetaStore.updateWorkspace: could not update workspace: " + encodedWorkspaceName + " for user " + userId, null));
            }
            if (renameUser) {
                SimpleMetaStoreUtil.moveMetaFile(userMetaFolder, workspaceInfo.getUniqueId(), newWorkspaceId);
                workspaceInfo.setUniqueId(newWorkspaceId);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

