/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.ds;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.orion.server.cf.ds.GenericDeploymentPackager;
import org.eclipse.orion.server.cf.ds.GenericDeploymentPlanner;
import org.eclipse.orion.server.cf.ds.IDeploymentPackager;
import org.eclipse.orion.server.cf.ds.IDeploymentPlanner;
import org.eclipse.orion.server.cf.ds.IDeploymentService;
import org.eclipse.orion.server.cf.ds.objects.Plan;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;

public final class DeploymentService
implements IDeploymentService {
    private List<IDeploymentPlanner> planners = new ArrayList<IDeploymentPlanner>();
    private List<IDeploymentPackager> packagers = new ArrayList<IDeploymentPackager>();

    protected synchronized void bindPlanner(IDeploymentPlanner planner) {
        this.planners.add(planner);
    }

    protected synchronized void unbindPlanner(IDeploymentPlanner planner) {
        this.planners.remove(planner);
    }

    protected synchronized void bindPackager(IDeploymentPackager packager) {
        this.packagers.add(packager);
    }

    protected synchronized void unbindPackager(IDeploymentPackager packager) {
        this.packagers.remove(packager);
    }

    @Override
    public String getDefaultDeplomentPlannerId() {
        return GenericDeploymentPlanner.class.getCanonicalName();
    }

    @Override
    public IDeploymentPlanner getDefaultDeplomentPlanner() {
        return this.getDeploymentPlanner(this.getDefaultDeplomentPlannerId());
    }

    @Override
    public IDeploymentPlanner getDeploymentPlanner(String id) {
        if (id == null) {
            return null;
        }
        for (IDeploymentPlanner planner : this.planners) {
            if (!id.equals(planner.getId())) continue;
            return planner;
        }
        return null;
    }

    @Override
    public List<Plan> getDeploymentPlans(IFileStore contentLocation, ManifestParseTree manifest, IFileStore manifestStore) {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (IDeploymentPlanner planner : this.planners) {
            Plan plan = planner.getDeploymentPlan(contentLocation, manifest != null ? new ManifestParseTree(manifest) : null, manifestStore);
            if (plan == null) continue;
            plans.add(plan);
        }
        return plans;
    }

    @Override
    public String getDefaultDeplomentPackagerId() {
        return GenericDeploymentPackager.class.getCanonicalName();
    }

    @Override
    public IDeploymentPackager getDefaultDeplomentPackager() {
        return this.getDeploymentPackager(this.getDefaultDeplomentPackagerId());
    }

    @Override
    public IDeploymentPackager getDeploymentPackager(String id) {
        if (id == null) {
            return null;
        }
        for (IDeploymentPackager packager : this.packagers) {
            if (!id.equals(packager.getId())) continue;
            return packager;
        }
        return null;
    }
}

