/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.EWAHCompressedBitmap32;

public final class RunningLengthWord32
implements Cloneable {
    public EWAHCompressedBitmap32 parent;
    public int position;
    public static final int runninglengthbits = 16;
    private static final int literalbits = 15;
    public static final int largestliteralcount = Short.MAX_VALUE;
    public static final int largestrunninglengthcount = 65535;
    private static final int runninglengthplusrunningbit = 131071;
    private static final int shiftedlargestrunninglengthcount = 131070;
    private static final int notrunninglengthplusrunningbit = -131072;
    private static final int notshiftedlargestrunninglengthcount = -131071;

    RunningLengthWord32(EWAHCompressedBitmap32 a, int p) {
        this.parent = a;
        this.position = p;
    }

    public int getNumberOfLiteralWords() {
        return this.parent.buffer[this.position] >>> 17;
    }

    public boolean getRunningBit() {
        return (this.parent.buffer[this.position] & 1) != 0;
    }

    public int getRunningLength() {
        return this.parent.buffer[this.position] >>> 1 & 0xFFFF;
    }

    public void setNumberOfLiteralWords(int number) {
        int n = this.position;
        this.parent.buffer[n] = this.parent.buffer[n] | 0xFFFE0000;
        int n2 = this.position;
        this.parent.buffer[n2] = this.parent.buffer[n2] & (number << 17 | 0x1FFFF);
    }

    public void setRunningBit(boolean b) {
        if (b) {
            int n = this.position;
            this.parent.buffer[n] = this.parent.buffer[n] | 1;
        } else {
            int n = this.position;
            this.parent.buffer[n] = this.parent.buffer[n] & 0xFFFFFFFE;
        }
    }

    public void setRunningLength(int number) {
        int n = this.position;
        this.parent.buffer[n] = this.parent.buffer[n] | 0x1FFFE;
        int n2 = this.position;
        this.parent.buffer[n2] = this.parent.buffer[n2] & (number << 1 | 0xFFFE0001);
    }

    public int size() {
        return this.getRunningLength() + this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public RunningLengthWord32 clone() throws CloneNotSupportedException {
        RunningLengthWord32 answer = (RunningLengthWord32)super.clone();
        answer.parent = this.parent;
        answer.position = this.position;
        return answer;
    }
}

