/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth.github;

import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitHubOAuthConsumer
extends OAuthConsumer {
    private static final String EMAIL_PARAMETER = "email";
    private static final String USERNAME_PARAMETER = "login";
    private static final String ID_PARAMETER = "id";
    private static final String URL_PARAMETER = "url";
    private static final String PRIMARY_PARAMETER = "primary";
    private static final String VERIFIED_PARAMETER = "verified";
    private static final String PROFILE_URL = "https://api.github.com/user";
    private static final String EMAIL_URL = "https://api.github.com/user/emails";
    private String email;
    private String username;
    private String id;
    private String url;
    private boolean email_verified;

    public GitHubOAuthConsumer(OAuthAccessTokenResponse oauthAccessTokenResponse, String redirect) throws OAuthException {
        super(oauthAccessTokenResponse, redirect);
        this.getGitHubProfile();
        this.getGitHubEmail();
    }

    private void getGitHubProfile() throws OAuthException {
        String body = this.getServerResponse(PROFILE_URL);
        try {
            JSONObject json = new JSONObject(body);
            this.username = json.getString(USERNAME_PARAMETER);
            this.id = json.getString(ID_PARAMETER);
            this.url = json.getString(URL_PARAMETER);
        }
        catch (JSONException jSONException) {
            throw new OAuthException("An error occured while authenticating the user");
        }
    }

    private void getGitHubEmail() throws OAuthException {
        String body = this.getServerResponse(EMAIL_URL);
        try {
            JSONArray json = new JSONArray(body);
            int i = 0;
            while (i < json.length()) {
                JSONObject emailObject = json.getJSONObject(i);
                boolean primary = emailObject.getBoolean(PRIMARY_PARAMETER);
                if (primary) {
                    this.email_verified = emailObject.getBoolean(VERIFIED_PARAMETER);
                    this.email = emailObject.getString(EMAIL_PARAMETER);
                    break;
                }
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new OAuthException("An error occured while authenticating the user");
        }
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.url) + "/" + this.id;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getUsername() {
        return this.username.replaceAll("-", "");
    }

    @Override
    public boolean isEmailVerifiecd() {
        return this.email_verified;
    }
}

