/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.server.authentication.form.FormAuthHelper;
import org.eclipse.orion.server.authentication.oauth.OAuthConsumer;
import org.eclipse.orion.server.authentication.oauth.OAuthException;
import org.eclipse.orion.server.authentication.oauth.OAuthParams;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHelper {
    public static final String OAUTH = "oauth";
    public static final String REDIRECT_TYPE = "redirect_type";
    static final String OAUTH_IDENTIFIER = "oauth_identifier";
    static final String OAUTH_DISC = "oauth-disc";

    public static void redirectToOAuthProvider(HttpServletRequest req, HttpServletResponse resp, OAuthParams oauthParams) throws OAuthException {
        try {
            OAuthClientRequest.AuthenticationRequestBuilder requestBuilder = OAuthClientRequest.authorizationProvider((OAuthProviderType)oauthParams.getProviderType()).setClientId(oauthParams.getClientKey()).setRedirectURI(oauthParams.getRedirectURI()).setResponseType(oauthParams.getResponseType()).setScope(oauthParams.getScope()).setState(oauthParams.getState());
            oauthParams.addAdditionsParams(requestBuilder);
            OAuthClientRequest request = requestBuilder.buildQueryMessage();
            resp.sendRedirect(request.getLocationUri());
        }
        catch (OAuthSystemException e) {
            throw new OAuthException(e);
        }
        catch (IOException e) {
            throw new OAuthException(e);
        }
    }

    public static OAuthConsumer handleOAuthReturnAndTokenAccess(HttpServletRequest req, HttpServletResponse resp, OAuthParams oauthParams) throws OAuthException {
        String error = req.getParameter("error");
        if (error != null) {
            throw new OAuthException(error);
        }
        String state = req.getParameter("state");
        if (state == null || !state.equals(oauthParams.getState())) {
            throw new OAuthException("The OAuth states do not match. Token provided by an unauthorized third party.");
        }
        String code = req.getParameter("code");
        if (code == null) {
            throw new OAuthException("No code provided");
        }
        try {
            OAuthClientRequest request = OAuthClientRequest.tokenProvider((OAuthProviderType)oauthParams.getProviderType()).setGrantType(oauthParams.getGrantType()).setClientId(oauthParams.getClientKey()).setClientSecret(oauthParams.getClientSecret()).setRedirectURI(oauthParams.getRedirectURI()).setCode(code).buildBodyMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthAccessTokenResponse oauthAccessTokenResponse = oAuthClient.accessToken(request, oauthParams.getTokenResponseClass());
            OAuthConsumer consumer = oauthParams.getNewOAuthConsumer(oauthAccessTokenResponse);
            return consumer;
        }
        catch (OAuthSystemException e) {
            throw new OAuthException(e);
        }
        catch (OAuthProblemException e) {
            throw new OAuthException(e);
        }
    }

    public static void handleLogin(HttpServletRequest req, HttpServletResponse resp, OAuthConsumer oauthConsumer) throws OAuthException, IOException {
        if (oauthConsumer == null || OAuthUtils.isEmpty((String)oauthConsumer.getIdentifier())) {
            throw new OAuthException("There is no Orion account associated with this Id. Please register or contact your system administrator for assistance.");
        }
        String redirect = oauthConsumer.getRedirect();
        UserInfo userInfo = OAuthHelper.getUser(oauthConsumer);
        if (userInfo == null) {
            if (!FormAuthHelper.canAddUsers()) {
                throw new OAuthException("There is no Orion account associated with this Id. Please register or contact your system administrator for assistance.");
            }
            String url = "/mixloginstatic/LoginWindow.html";
            url = String.valueOf(url) + "?oauth=create&email=" + oauthConsumer.getEmail();
            url = String.valueOf(url) + "&username=" + oauthConsumer.getUsername();
            url = String.valueOf(url) + "&identifier=" + oauthConsumer.getIdentifier();
            if (redirect != null) {
                url = String.valueOf(url) + "&redirect=" + redirect;
            }
            resp.sendRedirect(url);
            return;
        }
        String login = userInfo.getUniqueId();
        req.getSession().setAttribute("user", (Object)login);
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.login");
        if (logger.isInfoEnabled()) {
            logger.info("Login success: " + login + " oauth " + oauthConsumer.getIdentifier());
        }
        try {
            userInfo.setProperty("LastLoginTimestamp", new Long(System.currentTimeMillis()).toString());
            OrionConfiguration.getMetaStore().updateUser(userInfo);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        if (redirect != null) {
            resp.sendRedirect(redirect);
            return;
        }
        resp.sendRedirect("/index.html");
    }

    private static UserInfo getUser(OAuthConsumer oauthConsumer) {
        String openidIdentifier;
        UserInfo userInfo;
        block9: {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("OAuth", ".*\\Q" + oauthConsumer.getIdentifier() + "\\E.*", true, false);
            if (userInfo != null) {
                return userInfo;
            }
            openidIdentifier = oauthConsumer.getOpenidIdentifier();
            if (openidIdentifier != null && openidIdentifier.length() != 0) break block9;
            return null;
        }
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("OpenId", ".*\\Q" + openidIdentifier + "\\E.*", true, false);
            if (userInfo != null) {
                String openidsString = userInfo.getProperty("OpenId");
                String[] openIds = openidsString.split("\n");
                if (openIds.length == 1) {
                    userInfo.setProperty("OpenId", null);
                } else {
                    String newOpenIds = "";
                    String[] stringArray = openIds;
                    int n = openIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String openid = stringArray[n2];
                        if (!openid.equals(oauthConsumer.getOpenidIdentifier())) {
                            newOpenIds = String.valueOf(newOpenIds) + openid + "\n";
                        }
                        ++n2;
                    }
                    newOpenIds = newOpenIds.substring(0, newOpenIds.length() - 1);
                    userInfo.setProperty("OpenId", newOpenIds);
                }
                String oauths = userInfo.getProperty("OAuth");
                oauths = oauths != null && !oauths.equals("") ? String.valueOf(oauths) + '\n' : "";
                oauths = String.valueOf(oauths) + oauthConsumer.getIdentifier();
                userInfo.setProperty("OAuth", oauths);
                OrionConfiguration.getMetaStore().updateUser(userInfo);
                return userInfo;
            }
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
        }
        return null;
    }

    public static void handleReturnAndLinkAccount(HttpServletRequest req, HttpServletResponse resp, OAuthConsumer oauthConsumer) throws IOException, OAuthException {
        if (oauthConsumer != null) {
            String id = oauthConsumer.getIdentifier();
            if (OAuthUtils.isEmpty((String)id)) {
                throw new OAuthException("Authentication response is not sufficient");
            }
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html; charset=UTF-8");
            out.println("<html><head></head>");
            out.println("<body onload=\"window.opener.handleOAuthResponse('" + id + "');window.close();\">");
            out.println("</body>");
            out.println("</html>");
            out.close();
            return;
        }
    }

    public static String getAuthType() {
        return OAUTH;
    }

    static StringBuffer getAuthServerRequest(HttpServletRequest req) {
        Logger logger;
        String hostPref = PreferenceHelper.getString((String)"orion.auth.host", null);
        if (hostPref == null) {
            return req.getRequestURL();
        }
        StringBuffer result = new StringBuffer(hostPref);
        result.append(req.getServletPath());
        if (req.getPathInfo() != null) {
            result.append(req.getPathInfo());
        }
        if ((logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.oauth")).isInfoEnabled()) {
            logger.info("Auth server redirect: " + result.toString());
        }
        return result;
    }
}

