/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.jobs.LogCommand;
import org.eclipse.orion.server.git.objects.Log;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogJob
extends GitJob {
    private IPath filePath;
    private URI cloneLocation;
    private int page;
    private int pageSize;
    private ObjectId toObjectId;
    private ObjectId fromObjectId;
    private Ref toRefId;
    private Ref fromRefId;
    private String refIdsRange;
    private String pattern;
    private String messageFilter;
    private String authorFilter;
    private String committerFilter;
    private String sha1Filter;
    private String fromDate;
    private String toDate;
    private boolean mergeBaseFilter;
    private static Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.git");

    public LogJob(String userRunningTask, IPath filePath, URI cloneLocation, int page, int pageSize, ObjectId toObjectId, ObjectId fromObjectId, Ref toRefId, Ref fromRefId, String refIdsRange, String pattern, String messageFilter, String authorFilter, String committerFilter, String sha1Filter, boolean mergeBaseFilter, String fromDate, String toDate) {
        super(userRunningTask, false);
        this.filePath = filePath;
        this.cloneLocation = cloneLocation;
        this.page = page;
        this.pageSize = pageSize;
        this.toObjectId = toObjectId;
        this.fromObjectId = fromObjectId;
        this.toRefId = toRefId;
        this.fromRefId = fromRefId;
        this.refIdsRange = refIdsRange;
        this.pattern = pattern;
        this.messageFilter = messageFilter;
        this.authorFilter = authorFilter;
        this.committerFilter = committerFilter;
        this.sha1Filter = sha1Filter;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.mergeBaseFilter = mergeBaseFilter;
        this.setFinalMessage("Generating git log completed.");
    }

    protected IStatus performJob() {
        Repository db = null;
        LogCommand logCommand = null;
        try {
            File gitDir = GitUtils.getGitDir(this.filePath);
            db = FileRepositoryBuilder.create((File)gitDir);
            int aheadCount = 0;
            int behindCount = 0;
            int maxCount = -1;
            if (this.mergeBaseFilter) {
                RevWalk walk = new RevWalk(db);
                try {
                    walk.setRevFilter(RevFilter.MERGE_BASE);
                    RevCommit toRevCommit = walk.lookupCommit((AnyObjectId)this.toObjectId);
                    walk.markStart(toRevCommit);
                    RevCommit fromRevCommit = walk.lookupCommit((AnyObjectId)this.fromObjectId);
                    walk.markUninteresting(fromRevCommit);
                    RevCommit next = walk.next();
                    walk.reset();
                    walk.setRevFilter(RevFilter.ALL);
                    aheadCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)toRevCommit, (RevCommit)next);
                    behindCount = RevWalkUtils.count((RevWalk)walk, (RevCommit)fromRevCommit, (RevCommit)next);
                    if (next != null) {
                        this.toObjectId = next.toObjectId();
                        this.fromObjectId = null;
                    } else {
                        maxCount = 0;
                    }
                }
                finally {
                    walk.dispose();
                }
            }
            logCommand = new LogCommand(db);
            if (this.refIdsRange != null) {
                logCommand.add((AnyObjectId)this.toObjectId);
                if (this.fromObjectId != null) {
                    logCommand.not((AnyObjectId)this.fromObjectId);
                }
            } else {
                logCommand.all();
            }
            Log log = new Log(this.cloneLocation, db, null, this.pattern, this.toRefId, this.fromRefId);
            log.setMergeBaseFilter(this.mergeBaseFilter);
            if (this.messageFilter != null && this.messageFilter.length() > 0) {
                log.setMessagePattern(this.messageFilter);
                logCommand.setMessageFilter(this.messageFilter);
            }
            if (this.authorFilter != null && this.authorFilter.length() > 0) {
                log.setAuthorPattern(this.authorFilter);
                logCommand.setAuthFilter(this.authorFilter);
            }
            if (this.committerFilter != null && this.committerFilter.length() > 0) {
                log.setCommitterPattern(this.committerFilter);
                logCommand.setCommitterFilter(this.committerFilter);
            }
            if (this.sha1Filter != null && this.sha1Filter.length() > 0) {
                log.setSHA1Pattern(this.sha1Filter);
                logCommand.setSHA1Filter(this.sha1Filter);
            }
            if (this.fromDate != null && this.fromDate.length() > 0) {
                log.setFromDate(this.fromDate);
                if (this.toDate != null && this.toDate.length() > 0) {
                    log.setToDate(this.toDate);
                    logCommand.setDateFilter(this.fromDate, this.toDate);
                } else {
                    logCommand.setDateFilter(this.fromDate, null);
                }
            } else if (this.toDate != null && this.toDate.length() > 0) {
                log.setToDate(this.toDate);
                logCommand.setDateFilter(null, this.toDate);
            }
            if (this.page > 0) {
                logCommand.setSkip((this.page - 1) * this.pageSize);
                logCommand.setMaxCount(this.pageSize + 1);
            }
            if (this.pattern != null && !this.pattern.isEmpty()) {
                logCommand.addPath(this.pattern);
            }
            log.setPaging(this.page, this.pageSize);
            if (maxCount != -1) {
                logCommand.setMaxCount(maxCount);
            }
            Object commits = logCommand.call();
            log.setCommits((Iterable<RevCommit>)commits);
            JSONObject result = log.toJSON();
            if (this.mergeBaseFilter) {
                result.put("BehindCount", behindCount);
                result.put("AheadCount", aheadCount);
            }
            ServerStatus serverStatus = new ServerStatus(Status.OK_STATUS, 200, result);
            return serverStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when generating log for ref {0}", (Object)(logCommand != null ? logCommand.getRepository() : this.filePath));
            logger.error(msg, (Throwable)e);
            Status status = new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
            return status;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

