/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Cloud;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAppByGuidCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get application";
    private String appGuid;
    private App app;

    public GetAppByGuidCommand(Cloud cloud, String appGuid) {
        super(cloud);
        this.appGuid = appGuid;
    }

    @Override
    public ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.getCloud().getUrl());
            URI appsURI = targetURI.resolve("/v2/apps/" + this.appGuid);
            GetMethod getAppsMethod = new GetMethod(appsURI.toString());
            ServerStatus confStatus = HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, this.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            ServerStatus getStatus = HttpUtil.executeMethod((HttpMethodBase)getAppsMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject app = getStatus.getJsonData();
            JSONObject appJSON = app.getJSONObject("metadata");
            String summaryAppUrl = String.valueOf(appJSON.getString("url")) + "/summary";
            URI summaryAppURI = targetURI.resolve(summaryAppUrl);
            GetMethod getSummaryMethod = new GetMethod(summaryAppURI.toString());
            confStatus = HttpUtil.configureHttpMethod((HttpMethod)getSummaryMethod, this.getCloud());
            if (!confStatus.isOK()) {
                return confStatus;
            }
            getStatus = HttpUtil.executeMethod((HttpMethodBase)getSummaryMethod);
            if (!getStatus.isOK()) {
                return getStatus;
            }
            JSONObject summaryJSON = getStatus.getJsonData();
            this.app = new App();
            this.app.setAppJSON(appJSON);
            this.app.setSummaryJSON(summaryJSON);
            this.app.setGuid(appJSON.getString("guid"));
            this.app.setName(summaryJSON.getString("name"));
            return new ServerStatus(Status.OK_STATUS, 200, this.app.toJSON());
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    public App getApp() {
        return this.app;
    }
}

